"tps.sim.null1"<-
function(out = tpsout, nsim = 1, u.var = 0.5)
{
	N <- out$N
	nt <- out$nt
	np <- out$np
	D <- out$matrices$D
	G <- out$matrices$G
	cost <- out$cost
	ss.pure <- ifelse(is.null(out$ss.pure), 0, out$ss.pure)
	shat.pure.error <- out$shat.pure.error	
	# note : when reps should simulate below as chi sq dfe from 1-way anova
	pure.ss <- out$pure.ss	#
	set.seed(1201)	#*	u <- matrix(rnorm(N * nsim, 0, u.var), N, nsim)	
	u <- matrix(rnorm(np * nsim, 0, u.var), np, nsim)	
	#each col is a simulation
# u <- matrix(rep(rnorm(N,0,u.var),nsim),N,nsim) #each col is the same simulation
#*	u2 <- u[1:(N - out$nt),  ]
	u2 <- u[1:(np - out$nt),  ]
	sdu <- as.vector(colsd(u2))
	normu <- t(t(u2)/sdu)
	max.fold.test <- apply(abs(normu), 2, max)	
	# create a reasonable grid for the GCV search if not supplied
	l1 <- 1/D[np - nt - 1]	#finding upper
	tr <- np
	for(k in 1:8) {
		tr <- sum(1/(1 + l1 * D))
		if(tr < (nt + 0.050000000000000003))
			break
		l1 <- l1 * 2
	}
	l2 <- 1/D[1]	#finding lower
	for(k in 1:8) {
		tr <- sum(1/(1 + l2 * D))
		if((tr > (np * 0.94999999999999996)) | ((1 - (cost * (tr - nt) + 
			nt)/N) <= 0))
			break
		l2 <- l2/2
	}
	lambda.grid <- exp(seq(log(l2), log(l1),  , 80))
	nl <- length(lambda.grid)
	nd <- length(D)	#
#
## In S the fastest way to take a weighted sum of the columns of a matrix
##  is by  matrix multiplication
#
## Now make a big matrix that is the product of the lambdas and D's
#
	big.lD <- matrix(D, nrow = nl, ncol = nd, byrow = T) * matrix(
		lambda.grid, ncol = nd, nrow = nl)	#
#
#browser()
	RSS <- pure.ss + ((big.lD/(1 + big.lD))^2) %*% u^2
	MSE <- RSS/N	#
	trA <- (1/(1 + big.lD)) %*% rep(1, np)
	den <- (1 - (cost * (trA - nt) + nt)/N)	#
# If the denominator is negative then flag this as a bogus case
# by making the GCV function "infinity": 10^20
#
	den <- ifelse(den > 0, den, 1e-08)	#
	V <- MSE/as.vector(den)^2	#V <- ifelse(den > 0,V, 1e+20)	
#
## find global minimum of the GCV function on the grid
#
#
#gcv.grid <- data.frame(lambda.grid, trA, V, sqrt(RSS/(N - trA)))
#names(gcv.grid) <- c("lambda", "trA", "GCV", "shat")	#
# il is the index of the smallest value in the grid 
	il <- apply(V, 2, function(x)
	order(x)[1])	#il <- apply(V,2,order(gcv.grid$GCV)[1]
	lambda <- lambda.grid[il]
	eff.df <- trA[il]	#
#
#
	df.lm <- N - out$nt
	df.tps <- N - eff.df
	lambdaD <- as.matrix(D) %*% t(as.matrix(lambda))
	Dterm <- lambdaD/(1 + lambdaD)	
	##sse.tps <- ss.pure+ colsum((u*Dterm)^2)
	sse.tps <- RSS[cbind(il, 1:nsim)]
	sse.lm <- colsum(u2^2)
	df.tps <- N - eff.df	#wahba test
	V.lambda <- sse.tps/df.tps^2
	V.null <- sse.lm/df.lm^2
	wahba.test <- V.lambda/V.null	#reduced model test
	rm.test <- ((sse.lm - sse.tps)/(df.lm - df.tps))/(sse.tps/df.tps)	
	#eubanks test
#browser()
#lambdaD2 <- lambdaD[1:(np - out$nt),  ]
#         eub.s <- eubanks.s.fun(out$x,u,n.p=3)$shat
#         eubanks.test <- (colsum(u2^2/(1+lambdaD2)^2) - eub.s^2*colsum(1/(1+lambdaD2)^2))/eub.s^2*sqrt(2*colsum(1/(1+lambdaD2)^4))
	cval <- list()
	cval$wahba <- quantile(wahba.test, 0.050000000000000003)
	cval$rm <- quantile(rm.test, 0.94999999999999996)
	cval$maxft <- quantile(max.fold.test, 0.94999999999999996)	
	#	cval$eubanks <- quantile(eubanks.test,.95)
#  may need to return this way if trying to do many pvals
	list(wahba.null = sort(as.vector(wahba.test)), rm.null = sort(as.vector(
		rm.test)), mf.null = sort(as.vector(max.fold.test)), cval = 
		cval, lambda.range = range(lambda.grid))	
	#      eubanks.null=sort(as.vector(eubanks.test))
#	list(wahba.test = wahba.test, rm.test = rm.test, lambda = lambda, 
#		eff.df = eff.df, max.fold.test = max.fold.test, 	
#	     eubanks.test=eubanks.test, eub.s=eub.s, 
#	cval = cval, lambda.range = range(lambda.grid))
}
