dual.greedy <- function(A,nf,ns,etol=0,mattest=T)
  {
    A <- as.matrix(A)
    na <- dim(A)[1]
    nf <- as.integer(nf)
    ns <- as.integer(ns)
    ne <- na-nf

    if (ne==0) stop("number of eligible points is 0")
    if (ns==0) stop("number of points have to be added is 0")

    if(mattest)
      {
        for(i in 1:na)
          {
            if(!is.real(eigen(A)$values[i]))
              stop("Matrix isn't symmetric")
            if(eigen(A)$values[i]>etol==FALSE)
              stop("Matrix isn't positive definite")
          }
      }
    
    ans <- .Fortran("grddl",
                    A=as.double(A),
                    lda=as.integer(na),
                    na=as.integer(na),
                    nf=as.integer(nf),
                    ne=as.integer(ne),
                    ns=as.integer(ns),
                    S=integer(ne),
                    det=double(1),
                    integer(na), # ind
                    double(na*na), #As
                    as.integer(na),# LDAS
                    double(na*na), #Bs
                    as.integer(na),# LDBS
                    integer(1) #ierr
                    )
   
    list(S=ans$S,det=ans$det)
  }
