      DOUBLE PRECISION FUNCTION COVFN(COVTYPE,COVPAR,LAG)
      INTEGER COVTYPE
      DOUBLE PRECISION COVPAR(*),LAG
c     implementation of covariance functions
      IF (LAG.LT.0) THEN
         WRITE(*,*) "negative lag"
         COVFN=-1
         RETURN
      END IF
      IF (COVTYPE.EQ.1) THEN
c     exponential
         IF (LAG.GT.0) THEN
            COVFN=COVPAR(2)*EXP(-LAG/COVPAR(3))
         ELSE
            COVFN=COVPAR(1)+COVPAR(2)
         END IF
      ELSE IF (COVTYPE.EQ.2) THEN
c     gaussian
         IF (LAG.GT.0) THEN
            COVFN=COVPAR(2)*EXP(-(LAG*LAG/(COVPAR(3)*COVPAR(3))))
         ELSE
            COVFN=COVPAR(1)+COVPAR(2)
         END IF
      ELSE IF (COVTYPE.EQ.3) THEN
c     spherical
         IF (LAG.GT.COVPAR(3)) THEN
            COVFN=0
         ELSE IF (LAG.GT.0) THEN
            COVFN=COVPAR(2)*(1-1.5*LAG/COVPAR(3)+
     .                       0.5*LAG**3/COVPAR(3)**3)
         ELSE
            COVFN=COVPAR(1)+COVPAR(2)
         END IF
      ELSE IF (COVTYPE.EQ.4) THEN
c     linear
         IF (LAG.GT.0) THEN
            COVFN=COVPAR(2)*EXP(-LAG/COVPAR(3))
         ELSE
            COVFN=COVPAR(1)+COVPAR(2)
         END IF
      ELSE
         WRITE(*,*) "unknown covariance funtion"
         COVFN=-1
         RETURN
      END IF
      RETURN
      END
      
