\name{kds.ci}
\title{Confidence intervals for kernel density estimates}
\usage{kds.ci(data, h, g, x, alpha)
}
\alias{kds.ci}
\arguments{
Required:
\item{data}{data vector}
\item{h}{bandwidth for estimator}
\item{g}{bandwidth for second derivative estimator}
\item{x}{vector of x-values for confidence intervals}
\item{alpha}{1 - confidence coefficient}
}
\value{matrix with columns x, the two estimators, lower ci, upper
       ci, one row for each point in x.
}
\description{Confidence intervals for kernel density estimates
}
\examples{
data(dat.mixed)
# Figure 2.12 (p.63-4)
grid <- c(0:10)/2-2
ci <- kds.ci(dat.mixed,0.493,0.5,grid,0.05)
yli <- c(0,max(ci[,5]))
plot(ci[,1], ci[,2], type="l",cex=0.6, ylim=yli)
for(i in 1:11) # not 20
{
  lines(rep(ci[i,1],2), c(ci[i,4],ci[i,5]))
  lines(ci[i,1]+c(-0.03,0.03), rep(ci[i,4],2))
  lines(ci[i,1]+c(-0.03,0.03), rep(ci[i,5],2))
}
grid <- c(0:100)/20-2
true.density <- (0.6*exp(-0.5*(grid+1)^2)
   + 0.4*exp(-0.5*(grid-2)^2))/sqrt(2.0*pi)
density.mixed <- matrix(c(grid,true.density), length(grid), 2)
lines(density.mixed, lty=3)
}
\references{`Smoothing Techniques with Implementation in S', Wolfgang Haerdle,
Springer, 1991
}
