"dpih" <-
function (x, scalest = "minim", level = 2, gridsize = 401, range.x = range(x), 
        truncate = T) 
# Last changed: 16/06/95
{
        # Rename variables
        if (level > 5) 
                return("Level should be between 0 and 5")
        n <- length(x)
        M <- gridsize
        a <- range.x[1]
        b <- range.x[2]
        # Set up grid points and bin the data
        gpoints <- seq(a, b, length = M)
        gcounts <- linbin(x, gpoints, truncate)
        delta <- (b - a)/(M - 1)
        # Compute scale estimate
        # Perform plug-in steps 
        if (scalest == "stdev") {
                scalest <- sqrt(var(x))
        }
        else if (scalest == "iqr") {
                scalest <- (quantile(x, 3/4) - quantile(x, 1/4))/1.349
        }
        else if (scalest == "minim") {
                scalest <- (quantile(x, 3/4) - quantile(x, 1/4))/1.349
                scalest <- min(scalest, sqrt(var(x)))
        }
        if (level == 0) {
                hpi <- (24 * sqrt(pi)/n)^(1/3) * scalest
        }
        else if (level == 1) {
                # bandwidth for psi_2
                alpha <- (2/(3 * n))^(1/5) * sqrt(2) * scalest
                psi2hat <- bkfe(gcounts, 2, alpha, range.x = c(a, 
                        b), binned = T)
                hpi <- (6/(-psi2hat * n))^(1/3)
        }
        else if (level == 2) {
                # bandwidth for psi_4
                alpha <- ((2/(5 * n))^(1/7)) * sqrt(2) * scalest
                psi4hat <- bkfe(gcounts, 4, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_2
                alpha <- (sqrt(2/pi)/(psi4hat * n))^(1/5)
                psi2hat <- bkfe(gcounts, 2, alpha, range.x = c(a, 
                        b), binned = T)
                hpi <- (6/(-psi2hat * n))^(1/3)
        }
        else if (level == 3) {
                # bandwidth for psi_6
                alpha <- ((2/(7 * n))^(1/9)) * sqrt(2) * scalest
                psi6hat <- bkfe(gcounts, 6, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_4       
                alpha <- (-3 * sqrt(2/pi)/(psi6hat * n))^(1/7)
                psi4hat <- bkfe(gcounts, 4, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_2
                alpha <- (sqrt(2/pi)/(psi4hat * n))^(1/5)
                psi2hat <- bkfe(gcounts, 2, alpha, range.x = c(a, 
                        b), binned = T)
                hpi <- (6/(-psi2hat * n))^(1/3)
        }
        else if (level == 4) {
                # bandwidth for psi_8
                alpha <- ((2/(9 * n))^(1/11)) * sqrt(2) * scalest
                psi8hat <- bkfe(gcounts, 8, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_6
                alpha <- (15 * sqrt(2/pi)/(psi8hat * n))^(1/9)
                psi6hat <- bkfe(gcounts, 6, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_4
                alpha <- (-3 * sqrt(2/pi)/(psi6hat * n))^(1/7)
                psi4hat <- bkfe(gcounts, 4, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_2
                alpha <- (sqrt(2/pi)/(psi4hat * n))^(1/5)
                psi2hat <- bkfe(gcounts, 2, alpha, range.x = c(a, 
                        b), binned = T)
                hpi <- (6/(-psi2hat * n))^(1/3)
        }
        else if (level == 5) {
                alpha <- ((2/(11 * n))^(1/13)) * sqrt(2) * scalest
                psi10hat <- bkfe(gcounts, 10, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_8
                alpha <- (-105 * sqrt(2/pi)/(psi10hat * n))^(1/11)
                psi8hat <- bkfe(gcounts, 8, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_6
                alpha <- (15 * sqrt(2/pi)/(psi8hat * n))^(1/9)
                psi6hat <- bkfe(gcounts, 6, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_4
                alpha <- (-3 * sqrt(2/pi)/(psi6hat * n))^(1/7)
                psi4hat <- bkfe(gcounts, 4, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_2
                alpha <- (sqrt(2/pi)/(psi4hat * n))^(1/5)
                psi2hat <- bkfe(gcounts, 2, alpha, range.x = c(a, 
                        b), binned = T)
                hpi <- (6/(-psi2hat * n))^(1/3)
        }
        return(hpi)
}
