"dpik" <-
function (x, scalest = "minim", level = 2, kernel = "normal", 
        canonical = F, gridsize = 401, range.x = range(x), truncate = T) 
{
        # Set kernel constants
        if (level > 5) 
                return("Level should be between 0 and 5")
        if (canonical) 
                del0 <- 1
        else {
                if (kernel == "normal") 
                        del0 <- 1/((4 * pi)^(1/10))
                if (kernel == "box") 
                        del0 <- (9/2)^(1/5)
                if (kernel == "epanech") 
                        del0 <- 15^(1/5)
                if (kernel == "biweight") 
                        del0 <- 35^(1/5)
                if (kernel == "triweight") 
                        del0 <- (9450/143)^(1/5)
        }
        # Rename variables
        n <- length(x)
        M <- gridsize
        a <- range.x[1]
        b <- range.x[2]
        # Set up grid points and bin the data
        gpoints <- seq(a, b, length = M)
        gcounts <- linbin(x, gpoints, truncate)
        delta <- (b - a)/(M - 1)
        # Compute scale estimate
        # Perform plug-in steps 
        if (scalest == "stdev") {
                scalest <- sqrt(var(x))
        }
        else if (scalest == "iqr") {
                scalest <- (quantile(x, 3/4) - quantile(x, 1/4))/1.349
        }
        else if (scalest == "minim") {
                scalest <- (quantile(x, 3/4) - quantile(x, 1/4))/1.349
                scalest <- min(scalest, sqrt(var(x)))
        }
        if (level == 0) {
                psi4hat <- (3 * scalest^5)/(8 * sqrt(pi))
        }
        else if (level == 1) {
                # bandwidth for psi_4
                alpha <- (2 * (sqrt(2) * scalest)^7/(5 * n))^(1/7)
                psi4hat <- bkfe(gcounts, 4, alpha, range.x = c(a, 
                        b), binned = T)
        }
        else if (level == 2) {
                # bandwidth for psi_6
                alpha <- (2 * (sqrt(2) * scalest)^9/(7 * n))^(1/9)
                psi6hat <- bkfe(gcounts, 6, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_4 
                alpha <- (-3 * sqrt(2/pi)/(psi6hat * n))^(1/7)
                psi4hat <- bkfe(gcounts, 4, alpha, range.x = c(a, 
                        b), binned = T)
        }
        else if (level == 3) {
                # bandwidth for psi_8
                alpha <- (2 * (sqrt(2) * scalest)^11/(9 * n))^(1/11)
                psi8hat <- bkfe(gcounts, 8, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_6 
                alpha <- (15 * sqrt(2/pi)/(psi8hat * n))^(1/9)
                psi6hat <- bkfe(gcounts, 6, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_4 
                alpha <- (-3 * sqrt(2/pi)/(psi6hat * n))^(1/7)
                psi4hat <- bkfe(gcounts, 4, alpha, range.x = c(a, 
                        b), binned = T)
        }
        else if (level == 4) {
                # bandwidth for psi_10
                alpha <- (2 * (sqrt(2) * scalest)^13/(11 * n))^(1/13)
                psi10hat <- bkfe(gcounts, 10, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_8 
                alpha <- (-105 * sqrt(2/pi)/(psi10hat * n))^(1/11)
                psi8hat <- bkfe(gcounts, 8, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_6 
                alpha <- (15 * sqrt(2/pi)/(psi8hat * n))^(1/9)
                psi6hat <- bkfe(gcounts, 6, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_4 
                alpha <- (-3 * sqrt(2/pi)/(psi6hat * n))^(1/7)
                psi4hat <- bkfe(gcounts, 4, alpha, range.x = c(a, 
                        b), binned = T)
        }
        else if (level == 5) {
                # bandwidth for psi_12
                alpha <- (2 * (sqrt(2) * scalest)^15/(13 * n))^(1/15)
                psi12hat <- bkfe(gcounts, 12, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_10 
                alpha <- (945 * sqrt(2/pi)/(psi12hat * n))^(1/13)
                psi10hat <- bkfe(gcounts, 10, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_8 
                alpha <- (-105 * sqrt(2/pi)/(psi10hat * n))^(1/11)
                psi8hat <- bkfe(gcounts, 8, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_6 
                alpha <- (15 * sqrt(2/pi)/(psi8hat * n))^(1/9)
                psi6hat <- bkfe(gcounts, 6, alpha, range.x = c(a, 
                        b), binned = T)
                # bandwidth for psi_4 
                alpha <- (-3 * sqrt(2/pi)/(psi6hat * n))^(1/7)
                psi4hat <- bkfe(gcounts, 4, alpha, range.x = c(a, 
                        b), binned = T)
        }
        hpi <- del0 * (1/(psi4hat * n))^(1/5)
        return(hpi)
}
