\name{bkde2D}
\title{Compute a 2D Binned Kernel Density Estimate}
\usage{bkde2D(x, bandwidth, gridsize=c(51, 51), range.x=<<see below>>,
              truncate=T)
}
\alias{bkde2D}
\arguments{
Required:
\item{x}{a two-column matrix containing the observations  from  the
       distribution  whose  density  is to be estimated.  Missing
       values are not allowed.}
\item{bandwidth}{vector containing the bandwidth to be  used  in  each
       coordinate direction.}
Optional:
\item{gridsize}{vector containing the number of equally spaced points
       in each direction over which the density is to be estimated.}
\item{range.x}{a  list containing two vectors, where each vector contains
       the minimum and maximum values of x at which to compute
       the estimate for each direction.  The default is the
       minimum and maximum data values in each direction.}
\item{truncate}{logical flag: if TRUE, data with x values outside  the
       range specified by \code{range.x} are ignored.}
}
\value{ a list containing the following components:
\item{x1}{vector  of values of the grid points in the first coordinate
       direction at which the estimate was computed.}
\item{x2}{vector of values of the grid points in the second  coordinate
       direction at which the estimate was computed.}
\item{fhat}{matrix of density estimates over the mesh induced by \code{x1}
       and \code{x2}.}
}
\description{Returns  the  set of grid points in each coordinate direction
       , and the matrix of density estimates  over  the  mesh
       induced by the grid points. The kernel is the standard bivariate
       normal density.
}
\note{
       This is the binned approximation to the 2D kernel  density
       estimate.  Linear binning is used to obtain the bin counts
       and the Fast Fourier Transform is used to perform the discrete
       convolutions.  For each \code{x1}, \code{x2} pair the bivariate
       Gaussian kernel is  centered  on  that  location  and  the
       heights  of  the kernel, scaled by the bandwidths, at each
       datapoint are summed.  This sum, after a normalization, is
       the corresponding \code{fhat} value in the output.

}
\seealso{\code{\link{bkde}}, \code{\link{hist}}, \code{\link{density}}
}
\examples{
data(faithful)
x <- cbind(faithful$eruptions,faithful$waiting)
est <- bkde2D(x,bandwidth=c(0.7,7))
image(est$x1,est$x2,est$fhat,add=T)
contour(est$x1,est$x2,est$fhat,add=T)
}
\references{
Wand, M. P. (1994).  Fast Computation of Multivariate Kernel Estimators.  Journal of  Computational  and  Graphical Statistics, 3, 433-445.

Wand,  M.  P.  and Jones, M. C. (1995).  Kernel Smoothing. Chapman and Hall, London.
}
