\name{locpoly}
\title{Estimate Functions Using Local Polynomials}
\usage{locpoly(x, y, drv=0, degree=<<see below>>, kernel="normal",
               bandwidth, gridsize=401, bwdisc=25,
               range.x=<<see below>>,  binned=F, truncate=T)
}
\alias{locpoly}
\arguments{
Required:
\item{x}{vector of x data.  Missing values are not accepted.}
\item{bandwidth}{the kernel bandwidth smoothing parameter.  It may  be
       a single number or an array having length `gridsize', rep
       resenting a bandwidth that varies according to  the  loca
       tion of estimation.}
Optional:
\item{y}{vector  of  y data.  This must be same length as \code{x}, and
       missing values are not accepted.}
\item{drv}{order of derivative to be estimated.}
\item{degree}{degree of local  polynomial  used.  Its  value  must  be
       greater  than  or equal to the value of \code{drv}. The default
       value is of \code{degree} is \code{drv} + 1.}
\item{kernel}{\code{"normal"} - the Gaussian density function.}
\item{gridsize}{number of equally-spaced grid points  over  which  the
       function is to be estimated.}
\item{bwdisc}{number  of logarithmically-equally-spaced bandwidths on
       which \code{bandwidth} is discretised, to speed up computation.}
\item{range.x}{vector containing the minimum and maximum values of \code{x}
       at which to compute the estimate.}
\item{binned}{logical flag: if TRUE, then \code{x} and \code{y} are taken to be grid
       counts rather than raw data.}
\item{truncate}{logical flag: if TRUE, data with x values outside the
       range specified by \code{range.x} are ignored.}
}
\value{ if \code{y} is specified, a local polynomial  regression  esti
       mate of E[Y|X] (or its derivative) is computed.  If \code{y} is
       missing, a local polynomial estimate of the density of \code{x}
       (or its derivative) is computed.
\item{x}{vector  of sorted x values at which the estimate was com
       puted.}
\item{y}{vector of smoothed estimates for either the density or the
       regression at the corresponding \code{x}.}
}
\description{Estimates a probability density function, regression
       function or their derivatives using local polynomials. A  fast
       binned implementation over an equally-spaced grid is used.
}
\note{       Local  polynomial  fitting with a kernel weight is used to
       estimate either a density, regression  function  or  their
       derivatives.  In  the case of density estimation, the data
       are binned and the local fitting procedure is  applied  to
       the bin counts. In either case, binned approximations over
       an equally-spaced grid is used for fast  computation.  The
       bandwidth  may  be  either  scalar  or  a vector of length
       \code{gridsize}.
}
\seealso{\code{\link{bkde}}, \code{\link{density}}, \code{\link{dpill}}
}
\examples{
data(faithful)
x <- faithful$eruptions
est <- locpoly(x,bandwidth=0.25)
plot(est,type="l")
# local linear density estimate
y <- faithful$waiting
plot(x,y)
fit <- locpoly(x,y,bandwidth=0.25)
lines(fit)
# local linear regression estimate
}
\references{
Wand, M. P. and Jones, M. C.  (1995).   Kernel  Smoothing.
       Chapman and Hall, London.
}
