/* ../src/linbin2D.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* ccccccccc FORTRAN subroutine linbin2D.f cccccccccc */
/* Obtains bin counts for bivariate data */
/* via the linear binning strategy. In this version */
/* observations outside the mesh are ignored. */
/* Last changed: 25/08/95 */
/* Subroutine */ int lbtwod_(x, n, a1, a2, b1, b2, m1, m2, gcounts)
doublereal *x;
integer *n;
doublereal *a1, *a2, *b1, *b2;
integer *m1, *m2;
doublereal *gcounts;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer i;
    static doublereal delta1, delta2;
    static integer li1, li2, ind1, ind2, ind3, ind4;
    static doublereal rem1, rem2, lxi1, lxi2;

/*     Initialize grid counts to zero */
    /* Parameter adjustments */
    --gcounts;
    --x;

    /* Function Body */
    i__1 = *m1 * *m2;
    for (i = 1; i <= i__1; ++i) {
	gcounts[i] = 0.;
/* L10: */
    }
    delta1 = (*b1 - *a1) / (*m1 - 1);
    delta2 = (*b2 - *a2) / (*m2 - 1);
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	lxi1 = (x[i] - *a1) / delta1 + 1;
	lxi2 = (x[*n + i] - *a2) / delta2 + 1;
/*        Find the integer part of "lxi1" and "lxi2" */
	li1 = (integer) lxi1;
	li2 = (integer) lxi2;
	rem1 = lxi1 - li1;
	rem2 = lxi2 - li2;
	if (li1 >= 1) {
	    if (li2 >= 1) {
		if (li1 < *m1) {
		    if (li2 < *m2) {
			ind1 = *m1 * (li2 - 1) + li1;
			ind2 = *m1 * li2 + li1;
			ind3 = *m1 * (li2 - 1) + li1 + 1;
			ind4 = *m1 * li2 + li1 + 1;
			gcounts[ind1] += (1 - rem1) * (1 - rem2);
			gcounts[ind2] += rem1 * (1 - rem2);
			gcounts[ind3] += (1 - rem1) * rem2;
			gcounts[ind4] += rem1 * rem2;
		    }
		}
	    }
	}
/* L20: */
    }
    return 0;
} /* lbtwod_ */

