\name{est.variogram}
\title{Variogram Estimator}
\usage{est.variogram(point.obj, pairs.obj, v1, v2=v1) }
\alias{est.variogram}
\arguments{
\item{point.obj}{a point object generated by \code{point()}}
\item{pairs.obj}{a pairs object generated by \code{pairs()}}
\item{v1}{a variable to calculate semivariogram for}
\item{v2}{an optional variable name, if entered cross variograms will be created between \code{v1} and \code{v2}}
}
\value{A variogram object:
\item{lags}{vector of lag identifiers}
\item{bins}{vector of midpoints of each lag}
\item{classic}{vector of classic variogram estimates for each lag}
\item{robust}{vector of robust variogram estimates for each lag}
\item{med}{vector of median variogram estimates for each lag}
\item{n}{vector of the number of pairs in each lag}
}
\description{Calculate empirical variogram estimates. 

An object of class \code{variogram} contains empirical variogram estimates generated from a point object and a pairs object. A
variogram object is stored as a data frame containing six columns: \code{lags}, \code{bins}, \code{classic}, \code{robust}, \code{med}, and \code{n}. The length of each
vector is equal to the number of lags in the pairs object used to create the variogram object, say l. The \code{lags} vector contains the
lag numbers for each lag, beginning with one (1) and going to the number of lags (l). The \code{bins} vector contains the spatial midpoint
of each lag. The \code{classic}, \code{robust}, and \code{med} vectors contain the classical, robust, and median variogram estimates for each lag,
respectively (see Cressie, 1993, p. 75). The \code{n} vector contains the number of pairs of points in each lag. }
\seealso{\code{\link{point}}, \code{\link{pairs}}}
\examples{
maas.v<-est.variogram(maas.pts,maas.pairs,'zinc') 
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
