\name{lagplot}
\title{Lag Scatter Plot}
\usage{lagplot(point.obj, pairs.obj, v1, v2=v1, lag=1, std=F, query.a, xlim, ylim)}
\alias{lagplot}
\arguments{
\item{point.obj}{a point object generated by \code{point()}}
\item{pairs.obj}{a pairs object generated by \code{pairs()}}
\item{v1}{a variable to plot}
\item{v2}{an optional variable name, if entered the plot will be created between \code{v1} and \code{v2}}
\item{lag}{the lag to plot} 
\item{std}{a logical variable indicating whether the data should be standardized to their means and standard deviations before
plotting}
\item{query.a}{an optional variable name, if entered, the value of the variable will be displayed on the graphics device for points
identified by the user.}
\item{xlim}{a vector of length 2 indicating the x limits of the graphics page}
\item{ylim}{a vector of length 2 indicating the y limits of the graphics page}
}
\value{NULL}
\description{Create a spatially lagged scatter plot, e.g. plot z(s) versus z(s+h), where h is a lag in a pairs object. }
\note{When \code{query.a} is entered, the user will be prompted to identify points on the display device. Because each point in the
plot represents a pair of locations, the user must identify each point twice, once for the "from" point and once for the "to"
point. Querying is ended by pressing the middle mouse button on the mouse while the cursor is in the display window. }
\seealso{\code{\link{point}}, \code{\link{pairs}}}
\examples{
lagplot(maas.pts,maas.pairs,'zinc')
lagplot(maas.pts,maas.pairs,'zinc',lag=2,query.a='zinc')
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
