"krige.pvm" <-
function (s, point.obj, at, var.mod.obj, maxdist = NULL, extrap = F) 
{
    if (!inherits(point.obj, "point")) 
        stop("point.obj must be of class, \"point\".\n")
    if (!inherits(var.mod.obj, "variogram.model")) 
        stop("var.mod.obj must be of class, \"variogram.model\".\n")
    s$do <- c(rep(T, length(s$x)))
    if (!extrap) {
        s$do <- in.convex.hull(tri.mesh(point.obj$x, point.obj$y, 
            duplicate = "remove"), s$x, s$y)
    }
    at <- point.obj[[match(at, names(point.obj))]]
    krige.all.pvm(s, point.obj, at, var.mod.obj)
}
"krige.all.pvm" <-
function (s, point.obj, at, var.mod.obj) 
{
    distance <- function(x1, y1, x2, y2) ((x1 - x2)^2 + (y1 - 
        y2)^2)^0.5
    cat("\nUsing all points.\n  Preparing the kriging system matrix...")
    distvect <- dist(cbind(point.obj$x, point.obj$y))
    n <- attr(distvect, "Size")
    distmtrx <- matrix(0, n, n)
    distmtrx[lower.tri(distmtrx)] <- distvect
    distmtrx <- distmtrx + t(distmtrx)
    GMatrix <- var.mod.obj$model(distmtrx, var.mod.obj$parameters)
    GMatrix <- cbind(GMatrix, rep(1, length = nrow(GMatrix)))
    GMatrix <- rbind(GMatrix, c(rep(1, length = nrow(GMatrix)), 
        0))
    cat("\n  Inverting the matrix")
    if (nrow(GMatrix) > 100) 
        cat(" (and it's a big one)")
    cat("...")
    GMatrix.inv <- solve(qr(GMatrix))
    cat("\n---Hannes---\n")
    par <- NULL
    par <- c(var.mod.obj$parameter["nugget"], var.mod.obj$parameter["sill"], 
        var.mod.obj$parameter["range"])
    zhat <- matrix(0, length(s$x))
    #browser()
    sigma2hat <- matrix(0, length(s$x))
    cat("\n")
    hannes <- NULL
    hannes <- pvmkrige(point.obj$x, point.obj$y, point.obj$zinc, 
        length(point.obj$x), s$x, s$y, length(s$x), zhat, sigma2hat, 
        attr(var.mod.obj, "type"), par, GMatrix.inv, s$do)
    cat("---done---\n")
    a <- as.vector(hannes[[1]])
    b <- as.vector(hannes[[2]])
    a[a == -1] <- NA
    b[b == -1] <- NA
    #browser()
    s.o <- point(s)
    s.o$zhat <- a
    s.o$sigma2hat <- b
    return(s.o)
}
