#include "../tmeasure.h"

#ifdef USE_RDTSC 

int ELOG_CLOCK_CLOCK_SCALE=MHZ*1000000;

//#define RDTSC2(h,l)   __asm__ volatile ("rdtsc" : "=a"(l) , "=d"(h))
//#define RDTSC1(l)     __asm__ volatile ("rdtsc" : "=a"(l))

double tsc_to_s(long long tsc)
    {
    return (double)tsc/ELOG_CLOCK_CLOCK_SCALE;
    }

double tsc_to_ms(long long tsc)
    {
    return ((double)(tsc/(ELOG_CLOCK_CLOCK_SCALE/1000)));
    }

double tsc_to_us(long long tsc)
    {
    return ((double)(tsc/MHZ));
    }




/*
__inline__ unsigned long long int rdtsc()
{
  unsigned long long int x;
  __asm__ volatile (".byte 0x0f, 0x31" : "=A" (x));
  return x;
  } */

unsigned long long int rdtsc(void)
{
  unsigned int h,l;
  /* read Pentium cycle counter */
  __asm__(".byte 0x0f,0x31"
          :"=a" (l),
          "=d" (h));
  return ((unsigned long long int)h<<32)|l;
}

#else

#endif
