"plot.krige.map" <-
  function(obj, show.data=TRUE, show.snb=FALSE,
           snb.i=NULL, snb.j=NULL, var=FALSE, nlevels=12){
    if(!inherits(obj,"krige.map"))
      stop("argument is not a krige map!")
    # plot estimated z or var:
    zmin <- min(c(obj$z,obj$data[[obj$at]]),na.rm=T)
    zmax <- max(c(obj$z,obj$data[[obj$at]]),na.rm=T)
    zrange <- zmax-zmin
    zlim <-c(zmin,zmax)

    if(var){
      vmin <- min(obj$var,na.rm=T)
      vmax <- max(obj$var,na.rm=T)
      vrange <- vmax-vmin
      vlim <-c(vmin,vmax)
     
      vlevels <- pretty(vlim, nlevels)
      vllevels <- length(vlevels)
      vcolors <- topo.colors(vllevels+1)
    }
    
    levels <- pretty(zlim, nlevels)
    llevels <- length(levels)
    colors <- heat.colors(llevels+1)

    if(var){
      image(obj$x,obj$y,obj$var,col=vcolors,zlim=vlim)
      contour(obj$x,obj$y,obj$var,add=T,levels=vlevels)
    }
    else{
      image(obj,col=colors,zlim=zlim)
      contour(obj,add=T,levels=levels)
    }
    
    # add data points
    if(show.data){
      plevels<-apply(outer(obj$data[[obj$at]],levels,">="),1,
                     function(x) as.numeric(x)%*%as.numeric(x))
      points(obj$data$x,obj$data$y,col=c(colors)[plevels],pch=15)
      points(obj$data$x,obj$data$y,col="black",pch=0)
    }
    # let the user mark grid points and add their search neighbourhood
    if(show.snb){
      tmp<-expand.grid(obj$x,obj$y)
      points(tmp$Var1,tmp$Var2,type="n")
      if(is.null(snb.i) | is.null(snb.j)){
        cat("select points to place search neighbourhoods ...\n")
        lst<-identify(tmp$Var1,tmp$Var2,type="n")
        cat("\n")
      } else {
        if(length(snb.i)!=length(snb.i))
          stop("snb.i and snb.j have different lengths!")
        lst<-length(obj$y)*(snb.i-1)+snb.j
      }
      mypch<-0
      ret<-NULL
      ret$gridpoints<-NULL
      ret$snb<-list()
      cnt<-0
      for (i in lst){
        if(!is.null(obj$tile))
          it<-obj$tile[i]
        else
          it<-i
        cnt <- cnt+1
        ret$gridpoints <- c(ret$gridpoints,it)
        
        neighbours<-cbind(obj$data$x[obj$snb[,it]==1],obj$data$y[obj$snb[,it]==1])
        ret$snb[[cnt]]<-list()
        if(dim(neighbours)[1]!=0){
          points(neighbours,pch=mypch)
          ret$snb[[cnt]] <- (1:length(obj$snb[,it]))[obj$snb[,it]==1]
        
          hpts <- chull(neighbours)
          hpts <- c(hpts,hpts[1])
          lines(neighbours[hpts,])

          if(!is.null(obj$tile)){
            # tile:
            itpnts <- (obj$tile==it)
            tilepoints<-cbind(tmp$Var1[itpnts],tmp$Var2[itpnts])
            dx<-obj$x[2]-obj$x[1]
            dy<-obj$y[2]-obj$y[1]
            if(length(tilepoints)<9)
              points(tilepoints,pch=mypch+8)
            else{
              tilecorners<-
                tilepoints-cbind(rep(dx/2,length=dim(tilepoints)[1]),
                                 rep(dy/2,length=dim(tilepoints)[1]))
              tilecorners<-
                rbind(tilecorners,tilepoints+
                      cbind(rep(dx/2,length=dim(tilepoints)[1]),
                            rep(dy/2,length=dim(tilepoints)[1])))
              tilecorners<-
                rbind(tilecorners,tilepoints+
                      cbind(rep(dx/2,length=dim(tilepoints)[1]),
                            rep(-dy/2,length=dim(tilepoints)[1])))
              tilecorners<-
                rbind(tilecorners,tilepoints+
                      cbind(rep(-dx/2,length=dim(tilepoints)[1]),
                            rep(dy/2,length=dim(tilepoints)[1])))
            
              hpts<-chull(tilecorners)
              hpts<-c(hpts,hpts[1])
              lines(tilecorners[hpts,])
            }
          } else {
            # grid:
            gridpoint<-cbind(tmp$Var1[it],tmp$Var2[it])
            points(gridpoint,pch=mypch+8)
          }
        }
        
        mypch<-mypch+1
      }
    
      names(ret$snb)<-ret$gridpoints
      invisible(ret)
    }
  }
  
