      SUBROUTINE SRCHNB(LON0,LAT0,DO0,INDDO,N0,NDO,LON,LAT,N,NS,
     .                  RSEARCH,NSEARCH,NSMIN,NSMAX,
     .                  INDSRT,INDSNB,INDSNW,DIST)
      
      IMPLICIT NONE
      INTEGER N0,NDO,N,INDSNB(*),INDSNW(*),INDSRT(*),NSEARCH,NSMIN,
     .        NSMAX,NS,INDDO(*),DO0(*)
      DOUBLE PRECISION LAT0(*),LON0(*),LAT(*),LON(*),DIST(*),RSEARCH
c     
c     extract search neigbourhood for points x0 (LON0,LAT0) from
c     x (LON,LAT)
c
      INTEGER I,J,IERR

c     determine search neighbourhood
      DO 1 I=1,N
         INDSNW(I)=0
 1    CONTINUE

      DO 5 I=1,NDO
c        determine search neighbourhood for x0_i
c        calculate and sort distances
         CALL DVEC(LON0(INDDO(I)),LAT0(INDDO(I)),LON,LAT,DIST,N)
         CALL DPSORT(DIST,N,INDSRT,1,IERR)
         DO 111 J=1,N
            INDSNB(J)=0
 111     CONTINUE
c        handle a fixed search neigbourhood
         IF (NSEARCH.GT.0) THEN      
            IF(NSEARCH.GT.N) NSEARCH=N
            DO 8 J=1,NSEARCH
               INDSNB(J)=INDSRT(J) 
 8          CONTINUE
            NS=NSEARCH
         END IF
c        handle a fixed search radius
         IF (RSEARCH.GT.0) THEN
            DO 4 J=1,NSMIN
               INDSNB(J)=INDSRT(J)
 4          CONTINUE
 11         IF (DIST(INDSRT(J)).GT.RSEARCH .OR. J.GT.NSMAX) GO TO 6
            INDSNB(J)=INDSRT(J)
            J=J+1
            GO TO 11
 6          CONTINUE
         END IF
c        store search neigbourhood indices for x0_i in INDSNW, which
c        finally contains the union of all search neigbourhoods
         DO 600 J=1,N
            IF (INDSNB(J).GT.0) INDSNW(INDSNB(J))=INDSNB(J)
 600     CONTINUE
 5    CONTINUE

c     now INDSNW contains indices of the superset of all neigbourhoods.
c     strip now all "0"s from INDSNW and copy the indices back to INDSNB 
      I=1
      J=1
 700  IF (INDSNW(I).EQ.0) THEN
         I=I+1
      ELSE
         INDSNB(J)=INDSNW(I)
         I=I+1
         J=J+1
      END IF
      IF (I.LE.N) GO TO 700

      NS=J-1
      IF (NS.LT.N) THEN
         DO 701 I=NS+1,N
            INDSNB(I)=0
 701     CONTINUE
      END IF

      RETURN
      END
