      SUBROUTINE KRGPTS(XPTS,YPTS,ZPTS,VARPTS,NPTS,DOPTS,
     .                  LON,LAT,Z,N,
     .                  COVTYPE,COVPAR,COVMAT,LDCOV,C0VEC,LDC0,COV0,
     .                  EXTCOV,TREND,NTREND,RSEARCH,NSEARCH,NSMIN,NSMAX,
     .                  FWORK,LDFWRK,F0WORK,DIST,INDSNB,INDSNA,INDSRT,
     .                  KWORK,NKWORK,RHSWORK,IPIV,MODE,MU,LAMBDA,LDLMBD,
     .                  BITS,IERR)

      IMPLICIT NONE
      INTEGER NPTS,N,COVTYPE,TREND,NTREND,
     .        NSEARCH,NSMIN,NSMAX,MODE,IERR,INDSNB(*),INDSNA(*),
     .        INDSRT(*),IPIV(*),EXTCOV,LDCOV,DOPTS(*),
     .        LDC0,LDFWRK,LDLMBD,NKWORK,BITS(*)
      DOUBLE PRECISION XPTS(*),YPTS(*),ZPTS(*),VARPTS(*),
     .                 LON(*),LAT(*),Z(*),COVMAT(LDCOV,*),C0VEC(*),
     .                 COV0(*),RSEARCH,FWORK(LDFWRK,*),F0WORK(NTREND,*),
     .                 DIST(*),KWORK(NKWORK,*),RHSWORK(*),MU(*),
     .                 LAMBDA(*),
     .                 COVPAR(*) 

c     subroutine for kriging prediction on a given set of points
c
c     This subroutine calculates the overall covariance matrix and
c     calls KRIGE for the given points.
c
c     
c     parameters
c     XPTS,YPTS        lon/lat of prediction points
c     NPTS             no of prediction points
c     ZPTS,VARPTS      vectors to hold the output (prediction + variance)
c     LON,LAT,Z,N      data set
c     EXTCOV           indicates whether KRGPTS has to calculate the 
c                      covariance matrix itself or should use an external one 
c     ...              ... other work arrays to pass through to KRIGE

c     local variables
c     X0,Y0,Z0,VAR0    hold the input/output (coords. and prediction) for 
c                      a single point passed to KRIGE.

      DOUBLE PRECISION COVFN
      EXTERNAL COVFN

      EXTERNAL KRIGE, MATPR

c     local variables
      INTEGER I,J,K,L, INDDO(1), DO0(1), usesbbt, pcnt
      DOUBLE PRECISION DELTA, X0, Y0, Z0, VAR0
      CHARACTER*16 NAME

c     constants
      integer dbglvl
      dbglvl=0

c     prepare the covariance matrix
      IF (EXTCOV.NE.1) THEN
         DO 1000 I=1,N
            DO 1001 J=I,N
               COVMAT(I,J)=COVFN(COVTYPE,COVPAR,
     .                        SQRT((LON(I)-LON(J))*(LON(I)-LON(J))+
     .                             (LAT(I)-LAT(J))*(LAT(I)-LAT(J))))
               COVMAT(J,I)=COVMAT(I,J)
 1001       CONTINUE
 1000    CONTINUE
      END IF
c     loop over all points and pass them to KRIGE:
      if (bits(1+npts).ne.0) then
         usesbbt=1 
      end if
      PCNT=0
      DO 20 I=1,NPTS
         DO0(1)=DOPTS(I)
         PCNT=PCNT+1
         BITS(I) = PCNT
         X0=XPTS(I)
         Y0=YPTS(I)
c     the main work is now done by KRIGE:
         CALL KRIGE(X0,Y0,DO0,INDDO,1,LON,LAT,Z,N,
     .              COVTYPE,COVPAR,COVMAT,LDCOV,C0VEC,LDC0,COV0,TREND,
     .              NTREND,RSEARCH,NSEARCH,NSMIN,NSMAX,FWORK,LDFWRK,
     .              F0WORK,NTREND,
     .              DIST,INDSNB,INDSNA,INDSRT,KWORK,NKWORK,
     .              RHSWORK,IPIV,MODE,MU,Z0,LAMBDA,LDLMBD,VAR0,
     .              BITS(npts+2+(pcnt-1)*n),USESBBT,IERR)

c           extract results for this point
         IF (IERR.NE.0) THEN
            DOPTS(I)=DO0(1)
         ELSE
            ZPTS(I)=Z0
            VARPTS(I)=VAR0
         END IF
 20   CONTINUE

      RETURN
      END
