###--- >>> `muscle' <<<----- Effect of Calcium Chloride on Muscle Contraction in Rat Hearts

	## alias	 help(muscle)

##___ Examples ___:

##Don't run: 
##D data(muscle)
##D A <- model.matrix(~ Strip - 1, data=muscle)
##D rats.nls1 <- nls(log(Length) ~ cbind(A, rho^Conc), 
##D    data = muscle, start = c(rho=0.1), algorithm="plinear")
##D B <- coef(rats.nls1)
##D B
##D 
##D st <- list(alpha = B[2:22], beta = B[23], rho = B[1])  
##D rats.nls2 <- nls(log(Length) ~ alpha[Strip] + beta*rho^Conc,
##D                   data = muscle, start = st)
##D 
##D attach(muscle)
##D Muscle <- expand.grid(Conc = sort(unique(Conc)), 
##D                      Strip = levels(Strip))
##D Muscle$Yhat <- predict(rats.nls2, Muscle)
##D Muscle <- cbind(Muscle, logLength = rep(NA, 126))
##D ind <- match(paste(Strip, Conc), 
##D             paste(Muscle$Strip, Muscle$Conc))
##D Muscle$logLength[ind] <- log(Length)
##D detach()
##D 
##D xyplot(Yhat ~ Conc | Strip, Muscle, as.table = TRUE,
##D   ylim = range(c(Muscle$Yhat, Muscle$logLength), na.rm=TRUE),
##D   subscripts = TRUE, xlab = "Calcium Chloride concentration (mM)",
##D   ylab = "log(Length in mm)", panel = 
##D   function(x, y, subscripts, ...) {
##D      lines(spline(x, y))
##D      panel.xyplot(x, Muscle$logLength[subscripts], ...)
##D   })


## Keywords: 'datasets'.


