###--- >>> `apropos' <<<----- Find Objects by (Partial) Name

	## alias	 help(apropos)
	## alias	 help(find)

##___ Examples ___:

apropos("lm")
apropos(ls)
apropos("lq")

lm <- 1:pi
find(lm)        ##> ".GlobalEnv"   "package:base"
find(lm, num=T) ## .. numbers with these names
find(lm, num=T, mode="function")# only the second one
rm(lm)

apropos(".", mode="list")

# need a DOUBLE backslash `\\' (in case you don't see it anymore)
apropos("\\[")

# everything
length(apropos("."))

# those starting with `pr'
apropos("^pr")

# the 1-letter things
apropos("^.$")
# the 1-2-letter things
apropos("^..?$")
# the 2-to-4 letter things
apropos("^.{2,4}$")

# the 8-and-more letter things
apropos("^.{8,}$")
table(nchar(apropos("^.{8,}$")))

## Keywords: 'data', 'documentation', 'environment'.


