###--- >>> `cover.design' <<<----- Generate a coverage design.

##___ Examples ___:

# We wish to cover an 11 by 11 region with 9 points and take the
# best design out of 5 optimizations.
# This is a small candidate space, but we take num.nn=10 in order
# to speed computation for the example.
# There is no need to scale this example as x and y are commensurate.
grid11 <- expand.grid(list(x=1:11,y=1:11))
cover.des <- cover.design(grid11,9,nruns=5,num.nn=10)

## look at the design history
summary(cover.des)

# plot the region, and the optimum design:
plot(cover.des)

# display the change in the coverage criterion after each step of the
# optimization:
plot(x=attr(cover.des,'history')[,"step"],
	y=attr(cover.des,'history')[,"new.crit"])


## Keywords: 'FUNFITS'.


