###--- >>> `pca' <<<----- Principal Components Analysis

	## alias	 help(pca)

##___ Examples ___:

# principal components of the prim4 data
pcprim <- pca(prim4)
# plot of first and second principal components
plot(pcprim$rproj[,1], pcprim$rproj[,2])
# To label the points, uses `plot' with parameter `type="n"', followed by
# `text': cf. examples below.
# Place additional axes through x=0 and y=0:
plaxes(pcprim$rproj[,1], pcprim$rproj[,2])
# variance explained by the principal components
pcprim$evals*100.0/sum(pcprim$evals)
# In the implementation of the S function `prcomp', different results are
# produced.  Here is how to obtain these results, using the function `pca'.
# Consider the following result of `prcomp':
old <- prcomp(prim4)
# With `pca', one would do the following:
new <- pca(prim4, method=7)
# Data structures of `prcomp' are defined thus:
n <- nrow(prim4)
old$sdev = sqrt(new$evals/(n-1))
old$rotation = new$evec
center <- apply(old$x, 2, mean)
new$rproj[1,] <- old$x[1,] - center[1]
# One remark: the rotation matrix satisfies: 
# old$x == prim4 %*% old$rotation
# up to numerical precision.  However, up to 7 principal components only
# are now determined.  
#


## Keywords: 'multivariate', 'algebra'.


