###--- >>> `gnlmm' <<<----- Fit a Generalized Nonlinear Mixed Model

	## alias	 help(gnlmm)

##___ Examples ___:

library(gnlm)
# data objects
sex <- c(0,1)
sx <- tcctomat(sex)
dose <- matrix(rpois(20,10),nrow=2)
dd <- tvctomat(dose)
# vectors for functions
dose <- as.vector(t(dose))
sex <- c(rep(0,10),rep(1,10))
nest <- rbind(rep(1,10),rep(2,10))
y <- exp(0.2+0.3*dose+0.5*sex)+rgamma(20,2,5)+rep(rnorm(10),rep(2,10))
y <- restovec(matrix(y, nrow=2), nest=nest)
reps <- rmna(y, ccov=sx, tvcov=dd)
#
# log linear regression with gamma distribution
mu <- function(p) exp(p[1]+p[2]*sex+p[3]*dose)
print(z <- gnlr(y, dist="gamma", mu=mu, pmu=c(1,0,0), pshape=1))
gnlmm(y, dist="gamma", mu=mu, nest=nest, pmu=z$coef[1:3],
	pshape=z$coef[4], psd=0.1, points=3)
# or equivalently
gnlmm(y, dist="gamma", mu=~exp(b0+b1*sex+b2*dose), nest=nest,
	pmu=z$coef[1:3], pshape=z$coef[4], psd=0.1, points=3, envir=reps)
# or with identity link
print(z <- gnlr(y, dist="gamma", mu=~sex+dose, pmu=c(1,0,0), pshape=1))
gnlmm(y, dist="gamma", mu=~sex+dose, nest=nest, pmu=z$coef[1:3],
	pshape=z$coef[4], psd=0.1, points=3)
# or
gnlmm(y, dist="gamma", mu=~b0+b1*sex+b2*dose, nest=nest, pmu=z$coef[1:3],
	pshape=z$coef[4], psd=0.1, points=3, envir=reps)
#
# nonlinear regression with gamma distribution
mu <- function(p) p[1]+exp(p[2]+p[3]*sex+p[4]*dose)
print(z <- gnlr(y, dist="gamma", mu=mu, pmu=c(1,1,0,0), pshape=1))
gnlmm(y, dist="gamma", mu=mu, nest=nest, pmu=z$coef[1:4],
	pshape=z$coef[5], psd=0.1, points=3)
# or
mu2 <- function(p, linear) p[1]+exp(linear)
gnlmm(y, dist="gamma", mu=mu2, linear=~sex+dose, nest=nest,
	pmu=z$coef[1:4], pshape=1, psd=0.1, points=3)
# or
gnlmm(y, dist="gamma", mu=~b4+exp(b0+b1*sex+b2*dose), nest=nest,
	pmu=z$coef[1:4], pshape=z$coef[5], psd=0.1,
	points=3, envir=reps)
#
# include regression for the shape parameter with same mu function
shape <- function(p) p[1]+p[2]*sex
print(z <- gnlr(y, dist="gamma", mu=mu, shape=shape, pmu=c(1,0,0,1),
	pshape=rep(1,2)))
gnlmm(y, dist="gamma", mu=mu, shape=shape, nest=nest,
	pmu=z$coef[1:4], pshape=z$coef[5:6], psd=0.1, points=3)
# or
gnlmm(y, dist="gamma", mu=mu, shape=shape, nest=nest, pmu=z$coef[1:4],
	pshape=z$coef[5:6], psd=0.1, points=3, envir=reps)
# or
gnlmm(y, dist="gamma", mu=~b4+exp(b0+b1*sex+b2*dose), shape=shape,
	nest=nest, pmu=c(z$coef[4],z$coef[1:3]),
	pshape=z$coef[5:6], psd=0.1, points=3, envir=reps)



