

meta.DSL(rmeta)                              R Documentation

_R_a_n_d_o_m _e_f_f_e_c_t_s _(_D_e_r_S_i_m_o_n_i_a_n_-_L_a_i_r_d_) _m_e_t_a_-_a_n_a_l_y_s_i_s

_D_e_s_c_r_i_p_t_i_o_n_:

     Computes the individual odds ratios, the  summary odds
     ratio, the random effects variance, and Woolf's test
     for heterogeneity. The `print' method gives the summary
     and test for heterogeneity; the `summary' method also
     gives all the individual odds ratios and confidence
     intervals. Studies with zero or infinite odds ratio are
     omitted, as their variance cannot be calculated sensi-
     bly.

     The `plot' method draws a standard meta-analysis plot.
     The confidence interval for each study is given by a
     horizontal line, and the point estimate is given by a
     square whose height is inversely proportional to the
     standard error of the estimate.  The summary odds
     ratio, if requested, is drawn as a diamond with hori-
     zontal limits at the confidence limits and width
     inversely proportional to its standard error.

_U_s_a_g_e_:

     meta.DSL(ntrt, nctrl, ptrt, pctrl, names=NULL, data=NULL, subset=NULL)
     summary.meta.DSL(object)
     plot.meta.DSL(object,summary=T,summlabel="Summary",...)

_A_r_g_u_m_e_n_t_s_:

    ntrt: Number of subjects in treated/exposed group

   nctrl: Number of subjects in control group

    ptrt: Number of events in treated/exposed group

   pctrl: Number of events in control group

   names: names or labels for studies

    data: data frame to interpret variables

  subset: subset of studies to include

  object: a `meta.DSL' object

 summary: Plot the summary odds ratio?

summlabel: Label for the summary odds ratio

     ...: other graphical arguments

_V_a_l_u_e_:

     An object of class `meta.DSL' with `print', `plot' and
     `summary' methods and components:

   logOR: log odds ratios for individual studies

 selogOR: standard errors for log odds ratios

   logMH: log of Mantel-Haenszel summary odds ratio

 selogMH: standard of summary log odds ratio

  MHtest: Mantel-Haenszel chisquare and p-value testing the
          hypothesis that the summary odds ratio is 1

     het: Woolf's chisquare for heterogeneity, its degrees
          of freedom and p-value

    call: A copy of the function call

   names: A copy of the vector of names

 omitted: logical vector: was the study omitted because of
          0/Inf odds ratio

    tau2: Estimated random effects variance

_A_u_t_h_o_r_(_s_)_:

     Thomas Lumley

_R_e_f_e_r_e_n_c_e_s_:

_S_e_e _A_l_s_o_:

     `plot',`par',`meta.MH'

_E_x_a_m_p_l_e_s_:

     data(catheter)
     b<-meta.DSL(n.trt,n.ctrl,col.trt,col.ctrl,data=catheter,names=Name,subset=c(13,6,5,3,7,12,4,11,1,8,10,2))
     b
     summary(b)
     plot(b)
     e<-meta.DSL(n.trt,n.ctrl,inf.trt,inf.ctrl,data=catheter,names=Name,subset=c(13,6,3,12,4,11,1,14,8,10,2))
     e
     summary(e)
     plot(e)

