###--- >>> `Poisson' <<<----- The Poisson Distribution

	## alias	 help(dpois)
	## alias	 help(ppois)
	## alias	 help(qpois)
	## alias	 help(rpois)

##___ Examples ___:

-log(dpois(0:7, lambda=1) * gamma(1+ 0:7)) # == 1
Ni <- rpois(50, lam= 4); table(factor(Ni, 0:max(Ni)))

1 - ppois(10*(15:25), lambda=100)               # becomes 0 (cancellation)
    ppois(10*(15:25), lambda=100, lower=FALSE)  # no cancellation

par(mfrow = c(2, 1))
x <- seq(-0.01, 5, 0.01)
plot(x, ppois(x, 1), type="s", ylab="F(x)", main="Poisson(1) CDF")
plot(x, pbinom(x, 100, 0.01),type="s", ylab="F(x)",
     main="Binomial(100, 0.01) CDF")
dpois(c(0, 1, 0.17, 0.77), 1)

## Keywords: 'distribution'.


