interaction.plot            package:base            R Documentation

_T_w_o-_w_a_y _I_n_t_e_r_a_c_t_i_o_n _P_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     Plots the mean (or other summary) of the response for two-way
     combinations of factors, thereby illustrating possible
     interactions.

_U_s_a_g_e:

     interaction.plot(x.factor, trace.factor, response, fun = mean,
                      type = c("l", "p"), legend = TRUE,
                      trace.label = deparse(substitute(trace.factor)),
                      fixed = FALSE, xlab, ylab, ylim, lty, col = 1,
                      pch = c(1:9, 0, letters), ...)

_A_r_g_u_m_e_n_t_s:

x.factor: a factor whose levels will form the x axis.

trace.factor: another factor whose levels will form the traces.

response: a numeric variable giving the response

     fun: the function to compute the summary. Should return a single
          real value.

    type: the type of plot: lines or points.

  legend: logical. Should a legend be included?

trace.label: overall label for the legend.

   fixed: Should the legend be in the order of the levels of
          `trace.factor' or in the order of the traces at their
          right-hand ends?

    xlab: the x label of the plot.

    ylab: the y label of the plot.

    ylim: numeric of length 2 giving the y limits for the plot.

     lty: line type for the lines drawn, with sensible default.

     col: the color to be used for plotting.

     pch: a vector of plotting symbols or characters, with sensible
          default.

     ...: graphics parameters to be passed to the plotting routines.

_D_e_t_a_i_l_s:

     By default the levels of `x.factor' are plotted on the x axis in
     their given order, with extra space left at the right for the
     legend (if specified). If `x.factor' is an ordered factor and the
     levels are numeric, these numeric values are used for the x axis.

     The response and hence its summary can contain missing values. If
     so, the missing values and the line segments joining them are
     omitted from the plot (and this can be somewhat disconcerting).

     The graphics parameters `xlab', `ylab', `ylim', `lty', `col' and
     `pch' are given suitable defaults (and `xlim' and `xaxs' are set
     and cannot be overriden). The defaults are to cycle through the
     line types, use the foreground colour, and to use the symbols 1:9,
     0, and the capital letters to plot the traces.

_N_o_t_e:

     Some of the argument names and the precise behaviour are chosen
     for S-compatibility.

_E_x_a_m_p_l_e_s:

     data(ToothGrowth)
     attach(ToothGrowth)
     interaction.plot(dose, supp, len, fixed=TRUE)
     dose <- ordered(dose)
     interaction.plot(dose, supp, len, fixed=TRUE)
     detach()

     data(OrchardSprays)
     attach(OrchardSprays)
     interaction.plot(treatment, rowpos, decrease)
     interaction.plot(rowpos, treatment, decrease)
     ## order the rows by their mean effect
     rowpos <- factor(rowpos, levels=sort.list(tapply(decrease, rowpos, mean)))
     interaction.plot(rowpos, treatment, decrease)
     detach()

     data(esoph)
     attach(esoph)
     interaction.plot(agegp, alcgp, ncases/ncontrols)
     interaction.plot(agegp, tobgp, ncases/ncontrols, trace.label="tobacco",
                      fixed=TRUE)
     detach()

