###--- >>> `meanscore' <<<----- Mean Score Method for Missing Covariate Data in Logistic Regression Models

	## alias	 help(meanscore)

##___ Examples ___:

##Don't run: 
##D THE SIMULATED DATASET EXAMPLE

##Don't run: We use the simulated dataset which is stored in the matrix simNA.
##D You can load the dataset using:

data(simNA) 

help (simNA)
#gives a detailed description of the data.
      
##Don't run: To analyze this data using the meanscore function:

meanscore(y=simNA[,1],z=simNA[,2],x=simNA[,3])

##Don't run: This will give the following:
##D 
##D [1] "For calls to ms.nprev, input n1 or prev in the following order!!"
##D      ylevel z new.z  n1  n2
##D [1,]      0 0     0 310 150
##D [2,]      0 1     1 166  85
##D [3,]      1 0     0 177  86
##D [4,]      1 1     1 347 179
##D 
##D $parameters
##D                   est         se          z    pvalue
##D (Intercept) 0.0493998 0.07155138  0.6904103 0.4899362
##D x           1.0188437 0.10187094 10.0013188 0.0000000

##Don't run: If you extract the complete cases (n=500) to a matrix called
##D "complete", using

complete_simNA[!is.na(simNA[,3]),]

##Don't run: then 
summary(glm(complete[,1]~complete[,3], family="binomial"))

##Don't run: gives the following results:

##Don't run: Coefficients:
##D               Estimate Std. Error z value Pr(>|z|)    
##D (Intercept)    0.05258    0.09879   0.532    0.595    
##D complete[, 3]  1.01942    0.12050   8.460   <2e-16 ***


##Don't run: 
##D Notice that the Mean Score estimates above had smaller 
##D standard errors, reflecting the additional information
##D in the incomplete observations used in the analysis.
##D Also note that since z is a surrogate for x, it is not 
##D used in the complete case analysis.

 

##Don't run: THE ECTOPIC DATASET EXAMPLE

##Don't run: This is a real-data example of an application of Mean Score
##D to a case-control study of the association between ectopic 
##D pregnancy and sexually transmitted diseases (see Reilly and 
##D Pepe, 1995). To learn more about the dataset, type help(ectopic). 
##D 
##D The data frame called "ectopic" is in the data subfolder
##D of the meanscore library. You can load the data by typing:

data(ectopic)

##Don't run: The following lines will reproduce the results presented in Table 3 
##D of Reilly & Pepe (1995)

# use gonnorhoea, contracept and sexpatr as auxiliary variables
ectopic.z_ectopic[,3:5]

# the auxiliary variables defined above and the chlamydia antibody status 
# are the predictor variables in the logistic regression model          
ectopic.x_ectopic[,2:5]    

meanscore(x=ectopic.x,z=ectopic.z,y=ectopic[,1])


## Keywords: 'regression'.


