###--- >>> `groupedData' <<<----- Construct a groupedData Object

	## alias	 help(groupedData)
	## alias	 help(nfgroupedData)
	## alias	 help(nmgroupedData)
	## alias	 help([.groupedData)
	## alias	 help(as.data.frame.groupedData)

##___ Examples ___:

data(Orthodont)
Orth.new <-  # create a new copy of the groupedData object
  groupedData( distance ~ age | Subject,
              data = as.data.frame( Orthodont ),
              FUN = mean,
              outer = ~ Sex,
              labels = list( x = "Age",
                y = "Distance from pituitary to pterygomaxillary fissure" ),
              units = list( x = "(yr)", y = "(mm)") )
##Don't run: 
##D plot( Orth.new )         # trellis plot by Subject

formula( Orth.new )      # extractor for the formula
gsummary( Orth.new )     # apply summary by Subject
fm1 <- lme( Orth.new )   # fixed and groups formulae extracted from object

## Keywords: 'manip', 'attribute'.


