###--- >>> `stat.gnames' <<<----- Sort Genes According to the Value of a Statistic

	## alias	 help(stat.gnames)

##___ Examples ___:

## Calculating log ratio and performing a t test.
data(MouseArray)
## mouse.setup <- init.grid()
## mouse.data <- init.data() ## see \emph{init.data}
mouse.lratio <- stat.ma(mouse.data, mouse.setup)
cl <- c(rep(1,3), rep(2,3))
mouse.t2 <- stat.t2(mouse.lratio, cl)

## Looking at gene names
## Finding the top 10 t-statistics
stat.gnames(abs(mouse.t2$t), mouse.gnames, crit=10)

## Finding the top 1
stat.gnames(abs(mouse.t2$t), mouse.gnames, crit=0.01)

## Finding the 10 extreme M values in the first slide
stat.gnames(abs(mouse.lratio$M[, 1]), mouse.gnames, crit=10)

## Keywords: 'misc'.


