###--- >>> `qaptest' <<<----- Perform Quadratic Assignment Procedure (QAP) Hypothesis Tests for Graph-Level Statistics

	## alias	 help(qaptest)

##___ Examples ___:


#Generate three graphs
g<-array(dim=c(3,10,10))
g[1,,]<-rgraph(10)
g[2,,]<-rgraph(10,tprob=g[1,,]*0.8)
g[3,,]<-1; g[3,1,2]<-0              #This is nearly a clique

#Perform qap tests of graph correlation
q.12<-qaptest(g,gcor,g1=1,g2=2)
q.13<-qaptest(g,gcor,g1=1,g2=3)

#Examine the results
summary(q.12)
plot(q.12)
summary(q.13)
plot(q.13)

## Keywords: 'htest', 'network'.


