
#include <R.h>
#include <Rinternals.h>

#include "edesign.h"

#include <R_ext/Rdynload.h>

/* Fortran interface descriptions: */

// SUBROUTINE GRD(A,LDA,NA,NF,NE,NS,S,OPT,IND,AS,LDAS,BS,LDBS,INV,
//                LDINV,V,W,IERR)
static R_NativePrimitiveArgType grd_t[19] = {
    REALSXP, /* A */
    INTSXP,  /* LDA */
    INTSXP,  /* NA */
    INTSXP,  /* NF */
    INTSXP,  /* NE */
    INTSXP,  /* NS */
    INTSXP,  /* S */
    REALSXP, /* OPT */
    INTSXP,  /* IND */
    REALSXP, /* AS */
    INTSXP,  /* LDAS */
    REALSXP, /* BS */
    INTSXP,  /* LDBS */
    INTSXP,  /* LPTR */
    REALSXP, /* INV */
    INTSXP,  /* LDINV */
    REALSXP, /* V */
    REALSXP, /* W */
    INTSXP   /* IERR */
};

// SUBROUTINE GRDDL(A,LDA,NA,NF,NE,NS,S,OPT,IND,AS,LDAS,BS,LDBS,IERR)
static R_NativePrimitiveArgType grddl_t[14] = {
    REALSXP, /* A */
    INTSXP,  /* LDA */
    INTSXP,  /* NA */
    INTSXP,  /* NF */
    INTSXP,  /* NE */
    INTSXP,  /* NS */
    INTSXP,  /* S */
    REALSXP, /* OPT */
    INTSXP,  /* IND */
    REALSXP, /* AS */
    INTSXP,  /* LDAS */
    REALSXP, /* BS */
    INTSXP,  /* LDBS */
    INTSXP   /* IERR */
};

// SUBROUTINE CHANGE(A,LDA,NA,NF,NE,NS,S,OPT,IND,AS,LDAS,BS,LDBS,INV,
//                   LDINV,V,W,IERR)
static R_NativePrimitiveArgType change_t[19] = {
    REALSXP, /* A */
    INTSXP,  /* LDA */
    INTSXP,  /* NA */
    INTSXP,  /* NF */
    INTSXP,  /* NE */
    INTSXP,  /* NS */
    INTSXP,  /* S */
    REALSXP, /* OPT */
    INTSXP,  /* IND */
    REALSXP, /* AS */
    INTSXP,  /* LDAS */
    REALSXP, /* BS */
    INTSXP,  /* LDBS */
    INTSXP,  /* LPTR */
    REALSXP, /* INV */
    INTSXP,  /* LDINV */
    REALSXP, /* V */
    REALSXP, /* W */
    INTSXP   /* IERR */
};



static R_FortranMethodDef fortranMethods[] = {
    /* greedy */
    {"grd", (DL_FUNC) &F77_SUB(grd), 19, grd_t}, 
    /* dual.greedy */
    {"grddl", (DL_FUNC) &F77_SUB(grddl), 14, grddl_t}, 
    /* end */
    {NULL, NULL, 0}
};

/* C interface descriptions: */

// void entrp( ... )
static R_NativePrimitiveArgType entrp_t[29] = {
    REALSXP, /* A */
    INTSXP,  /* lda */
    INTSXP,  /* na */
    INTSXP,  /* nf */
    INTSXP,  /* ne */
    INTSXP,  /* ns */
    INTSXP,  /* S */
    REALSXP, /* opt */   
    INTSXP,  /* S_Work*/
    INTSXP,  /* F */
    INTSXP,  /* F */
    INTSXP,  /* ind */
    INTSXP,  /* ind1 */
    REALSXP, /* As */
    INTSXP,  /* ldas */
    REALSXP, /* Bs  */
    INTSXP,  /* ldbs */
    REALSXP, /* Cs  */
    INTSXP,  /* ldcs */
    REALSXP, /* Inv */
    INTSXP,  /* ldinv */
    REALSXP, /* W */
    REALSXP, /* WORK */
    INTSXP,  /* LWORK */
    INTSXP,  /* IWORK */
    REALSXP, /* tol */
    INTSXP,  /* maxcount */
    INTSXP,  /* iter */
    INTSXP  /* berbose */
};


static R_CMethodDef cMethods[] = {
    /* max.entropy */
    {"entrp", (DL_FUNC) entrp, 29, entrp_t}, 
    {NULL, NULL, 0}
};


void
R_init_edesign(DllInfo *info)
{
  R_registerRoutines(info, 
		     cMethods, 
                     NULL /*callMethods*/, 
		     fortranMethods, 
                     NULL /*externalMethods*/);
}
