dnl acinclude.m4
dnl
dnl autoconf macro to search for an installed contributed R package
dnl
AC_DEFUN(R_FIND_LIB,[
  AC_CACHE_CHECK([for R library $1],
  r_library_$1,[
if test -z "${R_HOME}" ; then
 R_HOME=`R RHOME`
fi

if test -z "${R_HOME}" ; then
  echo "Cannot find the R distribution!"
  exit 1 
fi

dnl identify PATH where the library is installed (multiple paths possible!)
dnl (one  gets eaten by autoconf, thats why the triple brackets below!)
cat >conftest.R <<EOT
paste.libs<-function(){
  out<-"PKG_LIBPATH_$1="
  outp<-""
  numfound<-0
  for (i in system.file("libs", pkg="$1")){
    p<-""
    if(nchar(i)!=0){
      pc<-strsplit(i,"/")[[[1]]]
        if(length(pc)>2){
        for (j in pc[[1:(length(pc)-2)]])
          if(nchar(j)>0) p<-paste(p,j,sep="/")
        numfound<-numfound+1
        if(nchar(outp)>0)
          outp<-paste(outp,p,sep=":")
        else
          outp<-p
      }
    }
  }
  out<-paste(out,outp,sep="")
  cat(paste(out,"\n","export PKG_LIBPATH_$1\nPKG_NUM=",
      as.character(numfound),"\n","export PKG_NUM\n",sep=""), file="./$1Libs")
}
paste.libs()
EOT

echo "source(\"conftest.R\")" | $R_HOME/bin/R --vanilla >/dev/null
rm -f conftest.R

eval "`cat ./$1Libs`"
rm -f ./$1Libs

if test -z "${PKG_LIBPATH_$1}" ; then
 echo "Cannot find the $1 library for R." 
 echo "Please install it, or set the environment R_LIBS so that it can be"
 echo "found in an R session."
 exit 1;
else
 echo "package found"
fi

if test "${PKG_NUM}" -gt 1; then
  echo "WARNING: Package  found more then once!"
fi

dnl choose the first component from the list PKG_LIBPATH_$1 which contains
dnl a dynamic or static package library in its ./lib subdirectory 
PKG_R_LIB_$1_found=false
for i in `echo ${PKG_LIBPATH_$1}| sed -e 's/:/ /g'`; do
dnl should use something like SHLIBEXT instead of .so:
  if test -f ${i}/lib/lib$1.so; then
    echo "found lib$1.so at: ${i}/lib"
    PKG_LIBPATH="${PKG_LIBPATH} -L${i}/lib"
    PKG_R_LIBS="${PKG_R_LIBS} -l$1"
    PKG_R_LIB_$1_found=true
    break
  else
    if test -f ${i}/lib/lib$1.a; then
      echo "found lib$1.a at: ${i}/lib"
      PKG_LIBPATH="${PKG_LIBPATH} -L${i}/lib"
      PKG_R_LIBS="${PKG_R_LIBS} -l$1"
      PKG_R_LIB_$1_found=true
      break
    fi
  fi
done
if test ! $PKG_R_LIB_$1_found; then
  echo "Neither dynamic nor static library for $1 found."
  echo "You may need to reinstall $1 with --create-lib-so or --create-lib-a"
  echo "as options to R INSTALL"
  exit 1
fi
AC_SUBST(PKG_LIBPATH)
AC_SUBST(PKG_R_LIBS)
    ]
  )
])
