"GS.Warping" <-
function (x, y, h, locations, samplenumber, M = 10, M.large = 20, 
        kernel = 4) 
# GOLDEN SECTION BOOTSTRAP FOR WARPING REGRESSION
# Expected parameters :
# x predictor, y response, h bandwidth,
# locations, samplenumber, optional : M, kernel
# M.large corresponding to oversmoothing bandwidth
{
        missingflag <- (is.na(x) | is.na(y))
        x <- x[!missingflag]
        y <- y[!missingflag]
        n <- length(x)
        delta <- h/M
        start <- min(x) - delta * (M.large + 0.1)
        origin <- (floor(start/delta) - 0.5) * delta
        numbin <- ceiling((max(x) + delta * (M.large + 0.1) - 
                origin)/delta) + 1
        max.notempty <- min(n + 1, numbin)
        # specification of binmesh like for usual WARPing.
        # range of binmesh determined by M.large
        # This object code contains all C-functions
        #
        # Call of the first C-routine for BINNING THE DATA
        # STEP 1 of the algorithm above
        binned.data <- .C("Hbinning", as.double(x), as.double(y), 
                as.double(start), as.double(delta), integer(numbin), 
                integer(1), integer(max.notempty), double(max.notempty), 
                integer(max.notempty), integer(n), as.integer(n))
        bin <- binned.data[[5]]
        nl <- binned.data[[6]]
        counts <- binned.data[[7]][1:(nl + 1)]
        ysum <- binned.data[[8]][1:(nl + 1)]
        index <- binned.data[[9]][1:(nl + 1)]
        indexobs <- binned.data[[10]]
        # Results of this step : bin, nl, counts, ysum
        # index and indexobs.
        #
        # Creation of wights first time corresponding to M.
        # First part of STEP 2
        kwe <- .C("createweights", result = double(M), as.integer(M), 
                as.integer(kernel))$result
        # Result of this step : kwe corresponding to M
        #
        # Weighting the bins corresponding to M and original data
        # Second part of STEP 2
        estimate <- .C("weightingbins", double(numbin), double(numbin), 
                as.integer(nl), as.integer(counts), as.double(ysum), 
                as.integer(index), as.double(kwe), as.integer(M))
        rM <- estimate[[1]]
        fM <- estimate[[2]]
        mM <- rM/fM
        missingflag <- is.na(mM)
        mM[missingflag] <- 0
        # Missings do not matter
        # Result of this step : mM, fM corresponding to M
        # and original data
        #
        # Computation of residuals, STEP 3
        residuals <- .C("residuals", result = double(n), as.double(y), 
                as.double(mM), as.integer(indexobs), as.integer(n))$result
        # Result of this step : residuals
        #
        # Creating weights corresponding to M.large.
        # First part of STEP 4.
        kwe.M.large <- .C("createweights", result = double(M.large), 
                as.integer(M.large), as.integer(kernel))$result
        # Result of this step : kwe.M.large
        #
        # Weighting bins corresponding to M.large
        # Second part of STEP 4.
        estimate.M.large <- .C("weightingbins", double(numbin), 
                double(numbin), as.integer(nl), as.integer(counts), 
                as.double(ysum), as.integer(index), as.double(kwe.M.large), 
                as.integer(M.large))
        mM.large <- estimate.M.large[[1]]/estimate.M.large[[2]]
        missingflag <- is.na(mM.large)
        mM.large[missingflag] <- 0
        # Result of this step : mM.large
        #
        # Identifying the locations, where the bootstrap
        # observations shall be generated
        locindex <- floor((locations - origin)/delta)
        locindex <- locindex[locindex > 0]
        locindex <- locindex[locindex < numbin]
        locationnumber <- length(locindex)
        #
        # Generation of bootstrap residuals using self-defined
        # S-function twopoint.  Generate blocks of samples such that
        # each block contains app. 10000 observations.
        # First part of STEP 5.
        sampleblock <- floor(10000/n)
        blocknumber <- floor(samplenumber/sampleblock)
        mMstar <- matrix(0, samplenumber, locationnumber)
        j <- 0
        while (j < blocknumber) {
                j <- j + 1
                twopoint <- twopoint.generator(sampleblock * 
                        n)
                resstar <- rep(residuals, sampleblock) * twopoint
                # Result of this step : resstar
                #
                # Compute sum over bootstrap observations in non-empty bins
                # Second part of STEP 5.
                ysumstar <- .C("bootstrapsums", as.double(resstar), 
                        as.double(mM.large), as.integer(bin), 
                        as.integer(indexobs), result = double(nl * 
                                sampleblock + 1), as.integer(n), 
                        as.integer(sampleblock), as.integer(nl))$result
                # Result of this step : ysumstar
                #
                # Weighting bins for bootstrap samples
                # Third part of STEP 5.
                z <- .C("bootstrapestimate", result = double(sampleblock * 
                        locationnumber), double(sampleblock * 
                        locationnumber), as.double(fM), as.integer(nl), 
                        as.double(ysumstar), as.double(kwe), 
                        as.integer(M), as.integer(locindex), 
                        as.integer(locationnumber), as.integer(bin), 
                        as.integer(sampleblock))$result
                mMstar[(1 + (j - 1) * sampleblock):(j * sampleblock), 
                        ] <- z
        }
        # LAST BLOCK
        # Like other blocks, but a different number of samples
        lastblock <- samplenumber - blocknumber * sampleblock
        twopoint <- twopoint.generator(lastblock * n)
        resstar <- rep(residuals, lastblock) * twopoint
        ysumstar <- .C("bootstrapsums", as.double(resstar), as.double(mM.large), 
                as.integer(bin), as.integer(indexobs), result = double(nl * 
                        lastblock + 1), as.integer(n), as.integer(lastblock), 
                as.integer(nl))$result
        z <- .C("bootstrapestimate", result = double(lastblock * 
                locationnumber), double(lastblock * locationnumber), 
                as.double(fM), as.integer(nl), as.double(ysumstar), 
                as.double(kwe), as.integer(M), as.integer(locindex), 
                as.integer(locationnumber), as.integer(bin), 
                as.integer(lastblock))$result
        mMstar[(1 + blocknumber * sampleblock):samplenumber, 
                ] <- z
        #
        # All samples of Regression Curves generated.
        result <- list(locations = (locindex + 0.5) * delta + 
                origin, mM = mM[locindex], mM.large = mM.large[locindex], 
                mMstar = mMstar)
        result
}

twopoint.generator <- function(ndata)
{
        a <- (1 - sqrt(5))/2
        b <- (1 + sqrt(5))/2
        gamma <- (5 + sqrt(5))/10
        zero.one <- (runif(ndata) <= gamma)
        result <- a * zero.one + b * (1 - zero.one)
        result
}
