"k.nn" <-
function (x, y, k) 
{
        missingflag <- (is.na(x) | is.na(y))
        x <- x[!missingflag]
        y <- y[!missingflag]
        # selection of missings
        n <- length(x)
        order.x <- order(x)
        y <- y[order.x]
        x <- x[order.x]
        # sorting x and y
        start <- 1 + floor(k/2)
        mk <- rep(NA, n)
        # fill the vector of estimates with missings
        mk[start] <- sum(y[1:k])/k
        # at x[start] the first k observations are the
        # k nearest neighbours.
        difference <- diff(y, k)/k
        # computes differences of y to the lag k
        mk[(start + 1):(n - start)] <- cumsum(c(mk[start], difference))
        # compute cumulative sums over differences
        result <- list(m = mk, x = x, y = y)
        result
}
