# S-function calling the C-routine for the regression smoothing
# by WARPing. Expected parameters : predictor x, response y
# bandwidth h, number of bins M (optional), the chosen kernel, 
# coded by 1 up to 5 (optional): 1 = Uniform, 2 = Triangle, 
# 3 = Epanechnikov, 4 = Quartic, 5 = Triweight
# and the na.handling (optional)
NW.Warping <-function(x,y,h,M=10,kernel=4,na.handling=0)
{
  missingflag<-(is.na(x) | is.na(y))
  x <-x[!missingflag]
  y <-y[!missingflag]
  n <-length(x)
  delta <-h/M
  start<-min(x)-h-delta*0.1
  origin<-(floor(start/delta)-0.5)*delta
  numbin<-ceiling((max(x)+h+delta*0.1-origin)/delta)+1
  max.notempty<-min(n+1,numbin)
  z<-.C("warpingregression",
    as.double(x),
    as.double(y),
    as.double(h),
    as.integer(M),
    double(numbin),
    double(numbin),
    result=double(numbin),
    double(M),
    as.double(origin),
    integer(numbin),
    integer(max.notempty),
    double(max.notempty),
    integer(max.notempty),
    as.integer(n),
    as.integer(numbin),
    as.integer(kernel),
    as.integer(na.handling))$result
  indexstart<-floor((min(x)-origin)/delta)
  indexend<-floor((max(x)-origin)/delta)
  result<-list(
    midpoints=origin+(0.5+c(indexstart:indexend))*delta,
    m=z[(indexstart+1):(indexend+1)],
    x=x,
    y=y)
  result
} 


