\name{Cv.warping}
\title{Cross-validation for WARPing density estimation}
\usage{Cv.warping(x, delta, kernel, Mstart=1, Mend)
}
\alias{Cv.warping}
\arguments{
\item{x}{data vector}
\item{delta}{step in bandwidth}
\item{kernel}{coded value of kernel (1 to 5)}
\item{Mstart}{left value of bandwidth is Mstart * delta}
\item{Mend}{right value of bandwidth is Mend * delta}
}
\value{       matrix  with  two  columns.  The first is Mstart:Mend, the
       second the CV value.
}
\description{Cross-validation for WARPing density estimation
}
\examples{
#test of CV.Warping -- p.109 -- quite slow
cv.simul<-function(n,k,seed)
{
  .Random.seed <<- seed
  simul <- matrix(0,k,2)
  for (i in 1:k)
  {
    data <- runif(n)<=0.6
    data <- data*(rnorm(n)-1)+(rnorm(n)+2)*(1-data)
    cv <- Cv.warping(data,0.1,5,Mstart=1,Mend=20)
    simul[i,] <- cv[sum((cv[,2]==min(cv[,2]))*c(1:20)),]
  }
  simul
}
seed.simul <- c(29,29,24,52,54,1,12,25,37,25,23,0)
simulation <- cv.simul(400,100,seed.simul)
mean(simulation[,1])
sqrt(var(simulation[,1]))
}
\references{`Smoothing Techniques with Implementation in S', Wolfgang Haerdle,
Springer, 1991
}
