\name{GS.Warping}
\title{Golden section bootstrap for WARPing regression}
\usage{GS.Warping(x, y, h, locations, samplenumber, M=10, M.large=20, kernel=4)
}
\alias{GS.Warping}
\arguments{Required:
\item{x}{predictor}
\item{y}{response}
\item{h}{bandwidth}
\item{locations}{suggested locations to evaluate the regression curve}
\item{samplenumber}{number of bootstrap samples}
Optional:
\item{M}{number of small bins}
\item{M.large}{oversmoothing bandwidth}
\item{kernel}{coded  kernel: 1 = uniform, 2 = triangle (ASH), 3 = Epanchenikov, 4 = quartic, 5 = triweight.}
}
\value{list with components locations of the estimates:
\item{mM}{the WARPing  regression  estimate,}
\item{mM.large}{the oversmoothed WARPing estimate and}
\item{mMstar}{the bootstrap regression  estimate.}
}
\description{Golden section bootstrap for WARPing regression
}
\examples{
data(faithful)
# Figure 7.1
gs <- GS.Warping(faithful$eruptions, faithful$waiting, h=0.4, c(0:33)/10+1.7, 5)
plot(gs$locations, gs$mMstar[1,], xlab="", ylab="", type="l")
for(i in 2:5) lines(gs$locations, gs$mMstar[i,],lty=i)

data(reg.dat)
# Figure 7.2
gs <- GS.Warping(dat.reg$x, dat.reg$y, h=0.1, c(1:28)/30, 5)
plot(dat.reg$x, dat.reg$m, ylim= c(-1.0,1.0), xlab="", ylab="", type="l")
for(i in 1:5) lines(gs$locations, gs$mMstar[i,]-gs$mM.large+gs$mM,lty=i)
}
\references{`Smoothing Techniques with Implementation in S', Wolfgang Haerdle,
Springer, 1991
}
