\name{NW.Warping}
\title{Nadaraya-Watson non-parametric regression via WARPing}
\usage{NW.Warping(x, y, h, M=10, kernel=4, na.handling=0)
}
\alias{NW.Warping}
\arguments{Required:
\item{x}{data vector}
\item{y}{data vector}
\item{h}{bandwidth}
Optional:
\item{M}{number of small bins}
\item{kernel}{code  for  kernel. 1 = uniform, 2 = triangle (ASH), 3 =
       Epanchenikov, 4 = quartic, 5 = triweight.}
\item{na.handling}{control handling of 0/0}
}
\value{       list with components midpoints, m (fitted curve), x and y.
       The curve is evaluated at the midpoints of the(small) bins
}
\description{Nadaraya-Watson non-parametric regression via WARPing
}
\examples{
data(dat.reg)
plot(dat.reg)
lines(dat.reg$x, dat.reg$m)
nw<-NW.Warping(dat.reg$x, dat.reg$y, 0.05)
lines(nw$midpoints, nw$m, lty=2)
nw<-NW.Warping(dat.reg$x, dat.reg$y, 0.10)
lines(nw$midpoints, nw$m, lty=3)
}
\references{`Smoothing Techniques with Implementation in S', Wolfgang Haerdle,
Springer, 1991
}
