\name{NW.kernel}
\title{Nadaraya-Watson non-parametric regression}
\usage{NW.kernel(x, y, h, kernel=4, points=100, na.handling=0)
}
\alias{NW.kernel}
\arguments{Required:
\item{x}{data vector}
\item{y}{data vector}
\item{h}{bandwidth}
\item{kernel}{code  for kernel.  1 = uniform, 2 = triangle (ASH), 3 =
       Epanchenikov, 4 = quartic, 5 = triweight, 6 = Gaussian,  7
       = cosinus}
Optional:
\item{points}{number of points to evaluate curve over the data range}
\item{na.handling}{How to handle 0/0. If 1 forces 0/0 = 0.}
}
\value{list with components grid, m (fitted curve), x and y
}
\description{Nadaraya-Watson non-parametric regression
}
\examples{
data(faithful)
# Figure 5.3
plot(faithful$eruptions,faithful$waiting)
nw<-NW.kernel(faithful$eruptions, faithful$waiting, 0.1)
lines(nw$grid, nw$m)
nw<-NW.kernel(faithful$eruptions, faithful$waiting, 0.4)
lines(nw$grid, nw$m, lty=2)
nw<-NW.kernel(faithful$eruptions, faithful$waiting, 0.8)
lines(nw$grid, nw$m, lty=3)

data(dat.reg)
# Figure 5.4
plot(dat.reg)
lines(dat.reg$x, dat.reg$m)
nw<-NW.kernel(dat.reg$x, dat.reg$y, 0.05)
lines(nw$grid, nw$m, lty=2)
nw<-NW.kernel(dat.reg$x, dat.reg$y, 0.10)
lines(nw$grid, nw$m, lty=3)
}
\references{`Smoothing Techniques with Implementation in S', Wolfgang Haerdle,
Springer, 1991
}
