\name{k.nn}
\title{k-nearest neighbour non-parametric regression}
\usage{k.nn(x, y, k)
}
\alias{k.nn}
\arguments{
\item{x}{data vector}
\item{y}{data vector}
\item{k}{number of neighbours}
}
\value{       list  of components m (the estimate at the points of x), x
       and y
}
\description{ k-nearest neighbour non-parametric regression
}
\examples{
data(faithful)
# Figure 5.6
par(mfrow=c(2,2))
plot(faithful$eruptions,faithful$waiting)
f.knn<-k.nn(faithful$eruptions,faithful$waiting,5)
lines(f.knn$x,f.knn$m)
plot(faithful$eruptions,faithful$waiting)
f.knn<-k.nn(faithful$eruptions,faithful$waiting,10)
lines(f.knn$x,f.knn$m)
plot(faithful$eruptions,faithful$waiting)
f.knn<-k.nn(faithful$eruptions,faithful$waiting,20)
lines(f.knn$x,f.knn$m)
plot(faithful$eruptions,faithful$waiting)
f.knn<-k.nn(faithful$eruptions,faithful$waiting,30)
lines(f.knn$x,f.knn$m)
}
\references{`Smoothing Techniques with Implementation in S', Wolfgang Haerdle,
Springer, 1991
}
