\name{kde}
\title{kernel density estimation}
\usage{kde(data, kernel, h, points=100)
}
\alias{kde}
\arguments{
Required:
\item{data}{vector of data}
\item{kernel}{coded  kernel:  =  Uniform, 2 = Triangle,  3 = Epanechnikov, 4 = Quartic, 5 = Triweight, 6 = Gaussian, 7 = Cosinus}
\item{h}{bandwidth}
Optional:
\item{points}{number of points at which to evaluate the density.}
}
\value{
       matrix  with  two columns giving the gridpoint and density
       estimate there.
}
\description{kernel density estimation
}
\note{Evaluates on a grid covering the range of the data.
}
\examples{
data(buffalo)
# Figure 2.8 
histogram(buffalo,8,0, ylim=c(0,0.022))
lines(kde(buffalo,3,8,100))

data(faithful)
# Q2.2 (see pp.215-6)
plot(kde(faithful$eruptions, 4, h=0.1, 80), type="l")
plot(kde(faithful$eruptions, 4, h=0.3, 80), type="l")
plot(kde(faithful$eruptions, 4, h=0.6, 80), type="l")

data(dat.mixed)
# Figure 2.11
test.kde<-kde(dat.mixed,6,0.493,100)
grid<-test.kde[,1]
true.density<- (0.6*exp(-0.5*(grid+1)^2)
    + 0.4*exp(-0.5*(grid-2)^2))/sqrt(2.0*pi)
density.mixed<-matrix(c(grid,true.density), length(grid), 2)
plot(density.mixed,type="n",xlab="dat.mixed",ylab="",cex=0.6)
lines(test.kde)
lines(density.mixed, lty=3)
}
\references{`Smoothing Techniques with Implementation in S', Wolfgang Haerdle,
Springer, 1991
}
