#include <stdio.h>
#include <math.h>
Hbinning(x,y,start,delta,bin,nl,counts,ysum,index,indexobs,n)
double *x,*y,*start,*delta,*ysum;
long *bin,*nl,*counts,*index,*indexobs,*n;
{
  long register i,j;
/* BINNING THE DATA FOR GOLDEN SECTION BOOTSTRAP */
  for (i=0;i<(*n);i++)
  {
    j=floor((x[i]-(*start))/(*delta));
    if (bin[j]==0)
    {
      (*nl)++;
      counts[(*nl)]=1;
      ysum[(*nl)]=y[i];
      index[(*nl)]=j;
      bin[j]=(*nl);
    }
    else
    {
      counts[bin[j]]++;
      ysum[bin[j]]+=y[i];
    }
    indexobs[i]=j;
  }
} /* END FUNCTION */
createweights(kwe,M,kernel)
double *kwe;
long *M,*kernel;
{
  long register i;
/* CREATING WEIGHTS */
  switch (*kernel)
  {
    case 1 :
/* uniform-kernel 						*/
    {
      for (i=0;i<M[0];i++)
        kwe[i]=1;
      break;
    }
    case 2 :
/* Triangle - kernel 						*/
    {
      for (i=0;i<M[0];i++)
        kwe[i]=1.0-(double)i/(double)M[0];
      break;
    }
    case 3 :
/* Epanechnikov - kernel 					*/
    {
      for (i=0;i<M[0];i++)
        kwe[i]=1.0-pow((double)i/(double)M[0], 2.0);
      break;
    }
    case 4 :
/* Quartic - kernel 						*/
    {
      for (i=0;i<M[0];i++)
        kwe[i]=pow(1.0-pow((double)i/(double)M[0],2.0),2.0);
      break;
    }
    case 5 :
/* Triweight-kernel 						*/
    {
      for (i=0;i<M[0];i++)
        kwe[i]=pow(1.0-pow((double)i/(double)M[0],2.0),3.0);
      break;
    }
    default: 
    {  
      printf("error in the choice of kernel %d!", *kernel);
      return;
    }
  }
} /* END FUNCTION */
weightingbins(rM,fM,nl,counts,ysum,index,kwe,M)
double *rM,*fM,*ysum,*kwe;
long *nl,*counts,*index,*M;
{
  long register i,j;
  for(i=1;i<(*nl)+1;i++)
  {
    for (j=1-(*M);j<(*M);j++)
    {
      fM[index[i]+j]+=kwe[abs(j)]*counts[i];
      rM[index[i]+j]+=kwe[abs(j)]*ysum[i];
    }
  }
}/* END FUNCTION */
residuals(res,y,mM,indexobs,n)
double *res,*y,*mM;
long *indexobs,*n;
{
  long register i;
  for(i=0;i<(*n);i++)
  {
    res[i] = y[i] - mM[indexobs[i]];
  }
} /* END FUNCTION */
bootstrapsums(residual,mM,bin,indexobs,ysumstar,n,samples,nl)
double *residual,*mM,*ysumstar;
long *bin,*indexobs,*n,*samples,*nl;
{
  long register i,j;
  long counter,counter2;
  for(i=0;i<(*samples);i++)
  {
    counter=i*(*nl);
    counter2=i*(*n);
    for (j=0;j<(*n);j++)
    {
      ysumstar[counter+bin[indexobs[j]]]+=
      		residual[counter2+j]+mM[indexobs[j]];
    }
  }
} /* END FUNCTION */
bootstrapestimate(mMstar,rMstar,fM,nl,ysumstar,kwe,M,
		locindex,locationnumber,bin,samples)
double *mMstar,*rMstar,*fM,*ysumstar,*kwe;
long *nl,*M,*locindex,*locationnumber,*bin,*samples;
{
  long register i,j,k;
  long index1,index2;
  double weight;
  for (j=0;j<(*locationnumber);j++)
  {
    index1=j*(*samples);
    for(k=1-(*M);k<(*M);k++)
    {
      index2=bin[locindex[j]+k];
      if(index2>0)
      {
        weight=kwe[abs(k)];
        for(i=0;i<(*samples);i++)
        {
          rMstar[index1+i]+=weight*ysumstar[i*(*nl)+index2];
        }
      }
    }
    for(i=0;i<(*samples);i++)
    {
      mMstar[index1+i]=rMstar[index1+i]/fM[locindex[j]];
    }
  }
} /* END FUNCTION */
