/* C-PROGRAM FOR KERNEL DENSITY ESTIMATION			*/
/* INTERFACE : fun = kernel function				*/
/* data = vector of observations				*/
/* n = number of observations					*/
/* grid = vector with gridpoints				*/
/* fh = vector with estimates					*/
/* kernel = number of kerneltype between 1 and 6		*/
/* 1 = Uniform, 2 = Triangle,					*/
/* 3 = Epanechnikov, 4 = Quartic,				*/
/* 5 = Triweight, 6 = Gaussian,					*/
/* 7 = Cosinus							*/
/* h = bandwidth of the kernel estimation			*/
/* points = number of gridpoints where the			*/
/* estimation should be calculated				*/
/* range = minimum and maximum of data				*/


#include<stdio.h>
#include<math.h>
static void *func;
/* pointer for the S function					*/
static double sfun();  /* added to make this compile */

kernelestimation(fun,data,n,grid,fh,kernel,h,points,range)
void **fun;
double *data,*grid,*fh,*h,*range;
long *n,*kernel,*points;
/* note the use of void **, since we have sent a list to C 	*/
{
  double gridmin,step,nh;
  long i,j,k1,k2;
  nh=h[0]*(double)n[0];
  func=fun[0];
  
/* left boundary of grid					*/

  gridmin=range[0]-h[0];
  
/* interval between two following points on the grid		*/
  step=(2.0*h[0]+range[1]-range[0])/(double)(points[0]-1);

/* grid								*/
  for (j=0;j<points[0];j++)
  {
    grid[j]=gridmin+step*(double)j;
  }
  
/* now the kernel function is set around each gridpoint		*/

  if(kernel[0]==6)
  {
    for(i=0;i<n[0];i++)
    {
      for(j=0;j<points[0];j++)
      {
        fh[j]+=sfun((grid[j]-data[i])/h[0])/nh;
      }
    }
  }
  else
/* Except for the Gaussian kernel (kernel[0]=6)			*/
/* the kernel weights are only positive in a			*/
/* interval fixed by the indices k1 and k2.			*/
  {
    for (i=0;i<n[0];i++)
    {
      k1=ceil((data[i]-h[0]-gridmin)/step);
      k2=floor((data[i]+h[0]-gridmin)/step);
      /*printf("%d %d\n", k1,k2);*/
      for (j=k1;j<k2+1;j++)
      {
     /* printf("%f %f %f %f\n",grid[j],data[i],h[0],(grid[j]-data[j])/h[0]);*/
        fh[j]+=sfun((grid[j]-data[i])/h[0])/nh;
      } /* endj */
    }  /* endi */
  } /* endif */
  return(0);
} /* end */

/* The following part contains the call of our S-function	*/
static double sfun(z)
double z;
{
  void *args[1],*values[1];
  double zz[1], *result;
  char *mode[1];
  long length[1];
  mode[0]="double";
  length[0]=1;
  args[0]=(void *)(zz);
  zz[0]=z;
  call_S(func, 1L, args,mode,length,0,1L,values);
  result=(double *)values[0];
  return(result[0]);
}  
  
