/* Algorithm for calculation of the L2-Cross-Validation		*/
/* for WARPing density estimation 				*/
#include<stdio.h>
#include<math.h>

cvwarping(x,fm,delta,rangem,cv,kwe,origin,bin,frequ,index,n,numbin,kernel)

/* x <==> data							*/
/* fm <==> vector == 0 will contain density estimates		*/
/* delta bandwidth						*/
/* rangem <==> range of smoothing parameter M			*/
/* cv <==> value of cross-validation corresponding to M		*/
/* kwe <==> weights depending on the different kernels		*/
/* origin <==> left border of first bin				*/
/* bin <==> vector == 0 protocol for non-empty bins		*/
/* frequ <==> absolute frequencies of non-empty bins		*/
/* index <==> index of non-empty bins 				*/
/* n <==> number of data 					*/
/* numbin <==> number of small bins 				*/
/* kernel <==> type of kernel coded with 1 to 5			*/

double*x,*fm,*delta,*cv,*kwe,*origin;
long*rangem,*n,*kernel,*bin,*frequ,*index,*numbin;
{
  register long M,i,j,k,indexi,z;
  double cm,h,estexp,intsquare;
  long nl,iabs;
  nl=0;
  
/* Binning the data						*/
/* Computation of index[] and frequ[] for the non-empty		*/
/* bins.  Number of last non-empty bin is nl			*/
 
  for (i=0;i<n[0];i++)
  {
    indexi=floor((x[i]-origin[0])/delta[0]);
/* the actual obs. belongs to the bin with number indexi		*/
    if (bin[indexi]==0)
/* if the actual observation is the first in that bin		*/
    {
      nl++;
/* the number of non-empty bins increases by 1			*/
      frequ[nl] = 1;
/* the number of obs. in this bin is 1 (at this time)		*/
      index[nl]=indexi;
      bin[indexi]=nl;
/* protocol of the position of the new				*/
/* non-empty bin (in frequ[] and index[])			*/
    }
    else
/* if the actual observation is not the first in this bin 	*/
    {
      frequ[bin[indexi]]++;
/* increase the number of obs. in belonging non-empty bin 	*/
    }
  }
/* The vector frequ contains nonzero values in positions 	*/
/* 1,2,3,..,nl.  The other values are prespecified  	*/
/* as 0, since frequ is installed as a 0-vector.  In		*/
/* analogy index contains the indices of the non-empty bins.  	*/
  for(M=rangem[0];M<rangem[1]+1;M++)
  {
    h=(double)M*delta[0];
/* resetting the vector for the density estimates		*/
    for(z=0;z<numbin[0];z++)
      fm[z]=0.0;
/* resetting the estimate for expectation of fm[x]		*/
    estexp=0.0;
/* resetting the value of the integral over fm[x]^2		*/
    intsquare=0.0;
/* Calculation of the kernel depending weights.			*/
/* The factor c(M) assures that sum(w.M(i/M),1-M,M-1)=M.	*/
/* Note, in formula of cm the division by [n * h] does not	*/
/* belong to the theoretical value of cm, but is a factor,	*/
/* which has to be multiplied one time, since fm=1/(nh)*..	*/

    switch ( *kernel )
    {
      case 1 :
/* uniform-kernel K(u)=c(M) * I(|u|<=1)				*/
/* c(M)=M/(2M-1)						*/
      {
        cm=(double)M/((double)(2*M-1)*(double)n[0]*h);
        for (i=0;i<M;i++)
          kwe[i]=cm;
        break;
      }
      case 2 :
/* Triangle - kernel K(u)=c(M)*(1- |u|) * I(|u|<=1)		*/
/* original Average-Shifted-Histogram-kernel			*/
/* c(M)=1							*/
      {
        cm=1.0/((double)n[0]*h);
        for (i=0;i<M;i++)
          kwe[i]=cm*(1-(double)i/(double)M);
        break;
      }
      case 3 :
/* Epanechnikov - kernel K(u)=c(M) * (1- u*u) * I(|u|<=1)	*/
/* c(M)=3*M^2/4*M^2-1)						*/
      {
        cm=(double) (3*M*M)/((double)(4*M*M-1)
      					*(double)n[0]*h);
        for (i=0;i<M;i++)
          kwe[i]=cm*(1-pow((double)i/(double)M, 2.0));
        break;
      }
      case 4 :
/* Quartic - kernel K(u)= c(M) * (1- u*u)^2 * I(|u|<=1)		*/
/* c(M)=15*M^4/(16*M^4-1)					*/
      {
        cm=0.9375/((1.0-0.0625*pow((double)M,-4.0))
      					*(double)n[0]*h);
        for (i=0;i<M;i++)
          kwe[i]=cm*pow(1-pow((double)i/(double)M,2.0),2.0);
        break;
      }
      case 5 :
/* Triweight-kernel K(u)=c(M)*(1-u*U)^3*I(|u|<=1)		*/
/* c(M)=35*M^6/(32*M^6+14/3*M^2-5/3)				*/
      {
        cm=1.09375/((1.0+0.14583333*pow((double)M,-4.0)
        -0.052083333*pow((double)M,-6.0))*(double)n[0]*h);
        for (i=0;i<M;i++)
          kwe[i]=cm*pow(1-pow((double)i/(double)M,2.0),3.0);
        break;
      }
      default: printf("error in the choice of kernel !");
      return;
    }
/* end of the switch-part					*/

/* Like Kernel estimates, where a kernel function is set	*/
/* around the observations, we group the calculated weights	*/
/* around the non-empty bins.					*/

    for (k=1;k<nl+1;k++)
    {
      for (i=1-M;i<M;i++)
      {
        fm[i+index[k]]=fm[i+index[k]]+kwe[abs(i)]*(double)frequ[k];
      }
    }
  
/* Estimate E[fm(X)] basing on leave one out estimates		*/
/* Need only non-empty bins					*/
    for(k=1;k<nl+1;k++)
      estexp+=fm[index[k]]*(double)frequ[k];
    estexp-=kwe[0]*n[0];
/* Note, weights kwe[] are divided by n*h			*/
    estexp /=(double)(n[0]-1);
/* Calculation of the integral over fm[x]^2			*/
    for(z=0;z<numbin[0];z++)
      intsquare+=fm[z]*fm[z];
    intsquare*=delta[0];
/* Calculation of value of cross-validation basing on		*/
/* calculated quantities.					*/
    cv[M-rangem[0]]=intsquare-2.0*estexp;
  }  /* end of loop over M */
    
}/* end */
   
      				        
