/* C-routine of WARPing-density-estimation for			*/
/* 1-dimensional data with 6 different kernels			*/
#include<stdio.h>
#include<math.h>

warp(x,fh,h,wM,origin,binmesh,counts,J,M,n,kernel)

/* x <==> data							*/
/* fh <==> vector == 0 will contain density estimates		*/
/* h bandwidth							*/
/* wM <==> weights depending on the differnet kernels		*/
/* origin <==> left border of first bin				*/
/* binmesh <==> vector == 0 protocol for non-empty bins		*/
/* counts <==> counts of observations in non-empty bins		*/
/* J <==> index of non-empty bins 				*/
/* M <==> number of small bins in one large bin			*/
/* n <==> number of data 					*/
/* kernel <==> type of kernel coded with 1 to 5			*/

double*x,*fh,*h,*wM,*origin;
long*M,*n,*kernel,*binmesh,*counts,*J;
{
  register long i,k,index;
  double delta,cm;
  long binnumber;
  delta=h[0]/(double)M[0];
  binnumber=0;
  
/* delta binwidth of small bins <==> h/M			*/
/* binnumber, integer to count the non-empty bins 		*/

/* Binning the data						*/

  for (i=0;i<n[0];i++)
  {
    index=floor((x[i]-origin[0])/delta);
/* the actual obs. belongs to the bin with number index		*/
    if (binmesh[index]==0)
/* if the actual observation is the first in that bin		*/
    {
      binnumber++;
/* the number of non-empty bins increases by 1			*/
      counts[binnumber] = 1;
/* the number of obs. in this bin is 1 (at this time)		*/
      J[binnumber]=index;
      binmesh[index]=binnumber;
/* protocol of the position of the new				*/
/* non-empty bin (in counts[] and J[])				*/
    }
    else
/* if the actual observation is not the first in this bin 	*/
    {
      counts[binmesh[index]]++;
/* increase the number of obs. in belonging non-empty bin 	*/
    }
  }
/* The vector counts contains nonzero values in positions 	*/
/* 1,2,3,..,binnumber.  The other values are prespecified  	*/
/* as 0, since counts is installed as a 0-vector.  In		*/
/* analogy J contains the indices of the non-empty bins.  	*/

/* Calculation of the kernel depending weights.			*/
/* The factor c(M) assures that sum(w.M(i/M),1-M,M-1)=M.	*/
/* Note, in formula of cm the division by [n * h] does not	*/
/* belong to the theoretical value of cm, but is a factor,	*/
/* which has to be multiplied one time, since fh=1/(nh)*..	*/

  switch ( *kernel )
  {
    case 1 :
/* uniform-kernel K(u)=c(M) * I(|u|<=1)				*/
/* c(M)=M/(2M-1)						*/
    {
      cm=(double)M[0]/((double)(2*M[0]-1)*(double)n[0]*h[0]);
      for (i=0;i<M[0];i++)
        wM[i]=cm;
      break;
    }
    case 2 :
/* Triangle - kernel K(u)=c(M)*(1- |u|) * I(|u|<=1)		*/
/* original Average-Shifted-Histogram-kernel			*/
/* c(M)=1							*/
    {
      cm=1.0/((double)n[0]*h[0]);
      for (i=0;i<M[0];i++)
        wM[i]=cm*(1-(double)i/(double)M[0]);
      break;
    }
    case 3 :
/* Epanechnikov - kernel K(u)=c(M) * (1- u*u) * I(|u|<=1)	*/
/* c(M)=3*M^2/4*M^2-1)						*/
    {
      cm=(double) (3*M[0]*M[0])/((double)(4*M[0]*M[0]-1)
      					*(double)n[0]*h[0]);
      for (i=0;i<M[0];i++)
        wM[i]=cm*(1-pow((double)i/(double)M[0], 2.0));
      break;
    }
    case 4 :
/* Quartic - kernel K(u)= c(M) * (1- u*u)^2 * I(|u|<=1)		*/
/* c(M)=15*M^4/(16*M^4-1)					*/
    {
      cm=0.9375/((1.0-0.0625*pow((double)M[0],-4.0))
      					*(double)n[0]*h[0]);
      for (i=0;i<M[0];i++)
        wM[i]=cm*pow(1-pow((double)i/(double)M[0],2.0),2.0);
      break;
    }
    case 5 :
/* Triweight-kernel K(u)=c(M)*(1-u*U)^3*I(|u|<=1)		*/
/* c(M)=35*M^6/(32*M^6+14/3*M^2-5/3)				*/
    {
      cm=1.09375/((1.0+0.14583333*pow((double)M[0],-4.0)
      -0.052083333*pow((double)M[0],-6.0))*(double)n[0]*h[0]);
      for (i=0;i<M[0];i++)
        wM[i]=cm*pow(1-pow((double)i/(double)M[0],2.0),3.0);
      break;
    }
    case 6 :
/* Gaussian kernel */
    {
      cm = 0.3989*4.0 /((double)n[0]*h[0]);
      for (i=0;i<M[0];i++)
        wM[i]=cm*exp(-8.0*pow((double)i/(double)M[0],2.0));
      break;
    }
    default: printf("error in the choice of kernel !");
    return;
  }
/* end of the switch-part					*/

/* Like Kernel estimates, where a kernel function is set	*/
/* around the observations, we group the calculated weights	*/
/* around the non-empty bins.					*/

  for (k=1;k<binnumber+1;k++)
  {
    for (i=1-M[0];i<M[0];i++)
    {
      fh[i+J[k]]=fh[i+J[k]]+wM[abs(i)]*(double)counts[k];
    }
  }
}
   
      				        
