"locpoly" <-
function (x, y, drv = 0, degree, kernel = "normal", bandwidth, 
        gridsize = 401, bwdisc = 25, range.x, binned = F, truncate = T) 
{
        if (missing(degree)) 
                degree <- drv + 1
        # Rename common variables
        if (missing(range.x) & (binned == F)) 
                if (missing(y)) {
                        extra <- 0.05 * (max(x) - min(x))
                        range.x <- c(min(x) - extra, max(x) + 
                                extra)
                }
                else {
                        range.x <- c(min(x), max(x))
                }
        M <- gridsize
        Q <- bwdisc
        a <- range.x[1]
        b <- range.x[2]
        pp <- degree + 1
        ppp <- 2 * degree + 1
        tau <- 4
        # Decide whether a density estimate or regression
        # estimate is required.
        # obtain density estimate
        # obtain regression estimate
        if (missing(y)) {
                y <- NULL
                n <- length(x)
                gpoints <- seq(a, b, length = M)
                xcounts <- linbin(x, gpoints, truncate)
                ycounts <- (M - 1) * xcounts/(n * (b - a))
                xcounts <- rep(1, M)
        }
        else {
                # Bin the data if not already binned
                if (binned == F) {
                        gpoints <- seq(a, b, length = M)
                        out <- rlbin(x, y, gpoints, truncate)
                        xcounts <- out$xcounts
                        ycounts <- out$ycounts
                }
                else {
                        xcounts <- x
                        ycounts <- y
                        M <- length(xcounts)
                        gpoints <- seq(a, b, length = M)
                }
        }
        # Set the bin width
        delta <- (b - a)/(M - 1)
        # Discretise the bandwidths
        if (length(bandwidth) == M) {
                hlow <- sort(bandwidth)[1]
                hupp <- sort(bandwidth)[M]
                hdisc <- exp(seq(log(hlow), log(hupp), length = Q))
                # Determine value of L for each member of "hdisc"
                Lvec <- floor(tau * hdisc/delta)
                # Determine index of closest entry of "hdisc" 
                # to each member of "bandwidth"
                if (Q > 1) {
                        lhdisc <- log(hdisc)
                        gap <- (lhdisc[Q] - lhdisc[1])/(Q - 1)
                        if (gap == 0) 
                                indic <- rep(1, M)
                        else {
                                tlhvec <- ((log(bandwidth) - 
                                 log(sort(bandwidth)[1]))/gap) + 
                                 1
                                indic <- round(tlhvec)
                        }
                }
                else indic <- rep(1, M)
        }
        else if (length(bandwidth) == 1) {
                indic <- rep(1, M)
                Q <- 1
                Lvec <- rep(floor(tau * bandwidth/delta), Q)
                hdisc <- rep(bandwidth, Q)
        }
        else {
                print("Bandwidth must be a scalar or an array of length gridsize")
                return()
        }
        # Allocate space for the kernel vector and final estimate
        dimfkap <- 2 * sum(Lvec) + Q
        fkap <- rep(0, dimfkap)
        curvest <- rep(0, M)
        midpts <- rep(0, Q)
        ss <- matrix(0, M, ppp)
        tt <- matrix(0, M, pp)
        Smat <- matrix(0, pp, pp)
        Tvec <- rep(0, pp)
        ipvt <- rep(0, pp)
        # Call FORTRAN routine "locpol"
        out <- .Fortran("locpol", as.double(xcounts), as.double(ycounts), 
                as.integer(drv), as.double(delta), as.double(hdisc), 
                as.integer(Lvec), as.integer(indic), as.integer(midpts), 
                as.integer(M), as.integer(Q), as.double(fkap), 
                as.integer(pp), as.integer(ppp), as.double(ss), 
                as.double(tt), as.double(Smat), as.double(Tvec), 
                as.integer(ipvt), as.double(curvest))
        curvest <- gamma(drv + 1) * out[[19]]
        return(list(x = gpoints, y = curvest))
}
