"sstdiag" <-
function (x, drv = 0, degree = 1, kernel = "normal", bandwidth, 
        gridsize = 401, bwdisc = 25, range.x, binned = F, truncate = T) 
{
        # Rename common variables
        if (missing(range.x) & (binned == F)) 
                range.x <- c(min(x), max(x))
        M <- gridsize
        Q <- bwdisc
        a <- range.x[1]
        b <- range.x[2]
        pp <- degree + 1
        ppp <- 2 * degree + 1
        tau <- 4
        # Bin the data if not already binned
        if (binned == F) {
                gpoints <- seq(a, b, length = M)
                xcounts <- linbin(x, gpoints, truncate)
        }
        else {
                xcounts <- x
                M <- length(xcounts)
                gpoints <- seq(a, b, length = M)
        }
        # Set the bin width
        delta <- (b - a)/(M - 1)
        # Discretise the bandwidths
        if (length(bandwidth) == M) {
                hlow <- sort(bandwidth)[1]
                hupp <- sort(bandwidth)[M]
                hdisc <- exp(seq(log(hlow), log(hupp), length = Q))
                # Determine value of L for each member of "hdisc"
                Lvec <- floor(tau * hdisc/delta)
                # Determine index of closest entry of "hdisc" 
                # to each member of "bandwidth"
                if (Q > 1) {
                        lhdisc <- log(hdisc)
                        gap <- (lhdisc[Q] - lhdisc[1])/(Q - 1)
                        if (gap == 0) 
                                indic <- rep(1, M)
                        else {
                                tlhvec <- ((log(bandwidth) - 
                                 log(sort(bandwidth)[1]))/gap) + 
                                 1
                                indic <- round(tlhvec)
                        }
                }
                else indic <- rep(1, M)
        }
        else if (length(bandwidth) == 1) {
                indic <- rep(1, M)
                Q <- 1
                Lvec <- rep(floor(tau * bandwidth/delta), Q)
                hdisc <- rep(bandwidth, Q)
        }
        else {
                print("Bandwidth must be a scalar or an array of length gridsize")
                return()
        }
        dimfkap <- 2 * sum(Lvec) + Q
        fkap <- rep(0, dimfkap)
        midpts <- rep(0, Q)
        ss <- matrix(0, M, ppp)
        uu <- matrix(0, M, ppp)
        Smat <- matrix(0, pp, pp)
        Umat <- matrix(0, pp, pp)
        work <- rep(0, pp)
        det <- rep(0, 2)
        ipvt <- rep(0, pp)
        SSTd <- rep(0, M)
        out <- .Fortran("sstdg", as.double(xcounts), as.double(delta), 
                as.double(hdisc), as.integer(Lvec), as.integer(indic), 
                as.integer(midpts), as.integer(M), as.integer(Q), 
                as.double(fkap), as.integer(pp), as.integer(ppp), 
                as.double(ss), as.double(uu), as.double(Smat), 
                as.double(Umat), as.double(work), as.double(det), 
                as.integer(ipvt), as.double(SSTd))
        SSTd <- out[[19]]
        return(list(x = gpoints, y = SSTd))
}
