\name{bkfe}
\title{Compute a Binned Kernel Functional Estimate}
\usage{bkfe(x, drv, bandwidth, gridsize=401, range.x=range(x), binned=F,
            truncate=F)
}
\alias{bkfe}
\arguments{
Required:
\item{x}{vector of observations from the distribution whose density
       is to be estimated.  Missing values are not allowed.}
\item{drv}{order of derivative in the density functional. Must  be  a
       non-negative even integer.}
\item{bandwidth}{the kernel bandwidth smoothing parameter.}
Optional:
\item{gridsize}{the number of equally-spaced points over which binning
       is performed.}
\item{range.x}{vector containing the minimum and maximum values  of  x
       at which to compute the estimate.  The default is the 
       minimum and maximum data values.}
\item{logical flag}{if TRUE, then x and y are taken to be grid
       counts rather than raw data}
\item{truncate}{logical flag: if TRUE, data with x values outside the
       range specified by range.x are ignored.}
}
\value{ the estimated functional.}
\description{       Returns  an estimate of a binned approximation to the kernel
       estimate of the  specified  density  functional.   The
       kernel is the standard normal density.
}
\note{
       The density functional of order \code{drv} is the  integral  of
       the  product  of  the density and its \code{drv}'th derivative.
       The kernel estimates of such quantities are computed using
       a  binned  implementation,  and the kernel is the standard
       normal density.

Estimates of this type were proposed by Sheather and Jones
       (1991).
}
\examples{
data(faithful)
x <- faithful$eruptions
est <- bkfe(x,drv=4,bandwidth=0.3)
}
\references{
Sheather, S. J. and Jones, M. C. (1991).  A reliable data-based bandwidth selection method for kernel density  estimation.   Journal of the Royal Statistical Society, Series B, 53, 683-690.

Wand, M. P. and Jones, M. C.  (1995).   Kernel  Smoothing. Chapman and Hall, London.
}
