/* ../src/rlbin.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* ccccccccc FORTRAN subroutine rlbin.f cccccccccc */
/* Obtains bin counts for univariate regression data */
/* via the linear binning strategy. If "trun=0" then */
/* weight from end observations is given to corresponding */
/* end grid points. If "trun=1" then end observations */
/* are truncated. */
/* Last changed: 06/02/95 */
/* Subroutine */ int rlbin_(x, y, n, a, b, m, trun, xcounts, ycounts)
doublereal *x, *y;
integer *n;
doublereal *a, *b;
integer *m, *trun;
doublereal *xcounts, *ycounts;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer i;
    static doublereal delta;
    static integer li;
    static doublereal rem, lxi;

/*     Initialize grid counts to zero */
    /* Parameter adjustments */
    --ycounts;
    --xcounts;
    --y;
    --x;

    /* Function Body */
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	xcounts[i] = 0.;
	ycounts[i] = 0.;
/* L10: */
    }
    delta = (*b - *a) / (*m - 1);
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	lxi = (x[i] - *a) / delta + 1;
/*        Find integer part of "lxi" */
	li = (integer) lxi;
	rem = lxi - li;
	if (li >= 1 && li < *m) {
	    xcounts[li] += 1 - rem;
	    xcounts[li + 1] += rem;
	    ycounts[li] += (1 - rem) * y[i];
	    ycounts[li + 1] += rem * y[i];
	} else if (li < 1 && *trun == 0) {
	    ++xcounts[1];
	    ycounts[1] += y[i];
	} else if (li >= *m) {
	    if (li == *m || *trun == 0) {
		++xcounts[*m];
		ycounts[*m] += y[i];
	    }
	}
/* L20: */
    }
    return 0;
} /* rlbin_ */

