is.odd<-function(x)
{
  x-as.integer(x/2)*2==1
}

andrews.trafo<-function(x1,v)
  {
    p<-length(x1)
    z<-0
    if(p==1)
      z<-1/sqrt(2)*x1[1]+0*v
    else if(p==2)
      z<-1/sqrt(2)*x1[1]+x1[2]*sin(v)
    else if(is.odd(p))
    {
      s1<-0
      s2<-0
      m<-(p-1)/2
      for(k in 1:m)
        s1<-s1+x1[2*k]*sin(k*v)
      for(k in 1:m)
        s2<-s2+x1[2*k+1]*cos(k*v)          
      z<-1/sqrt(2)*x1[1]+x1[2]*sin(v)+s1+s2        
    }
    else if(!is.odd(p))
    {
      s1<-0
      s2<-0
      m<-p/2
      for(k in 1:m)
        s1<-s1+x1[2*k]*sin(k*v)
      for(k in 1:m-1)
        s2<-s2+x1[2*k+1]*cos(k*v)          
      z<-1/sqrt(2)*x1[1]+x1[2]*sin(v)+s1+s2  
    }      
    else
      stop("wrong lines in x")
    z
  }

andrews.plot<-function(x, plot.res=50)
{
  x<-as.matrix(rbind(x))
  n<-dim(x)[[1]]
  if(n==1)
    stop("x should contain at least 2 rows!")
  v<-seq(-pi, pi, length=plot.res)
  limu<-min(andrews.trafo(x[1,],v))
  limo<-max(andrews.trafo(x[1,],v))
  for(i in 2:n)
  {
    limu<-min(c(andrews.trafo(x[i,],v),limu))
    limo<-max(c(andrews.trafo(x[i,],v),limo))
  }
  plot(v,andrews.trafo(x[1,],v), ylim=c(limu, limo), 
       type="l", axes=T, ylab="", main="Andrews Plot")
  for(i in 2:n)
    lines(v,andrews.trafo(x[i,],v))
}


identify.andrews <- function(x, plot.res=50)
{  
  x<-as.matrix(rbind(x))
  n<-dim(x)[[1]]
  if(n==1)
    stop("x should contain at least 2 rows!")
  v<-seq(-pi, pi, length=plot.res)
  xpoints<-rep(v, n)
  ypoints<-andrews.trafo(x[1,], v)
  if(!is.null(dimnames(x)))
    xnames<-rep(dimnames(x)[[1]][1], plot.res)
  else
      xnames<-rep(1, plot.res)
  
  for(i in 2:n)
  {
    ypoints<-c(ypoints, andrews.trafo(x[i,], v), recursive=T)
    if(!is.null(dimnames(x)))
      xnames<-c(xnames, rep(dimnames(x)[[1]][i], plot.res))
    else
      xnames<-c(xnames, rep(i, plot.res))
  }   
  ans<-identify(xpoints,ypoints,xnames)
  as.integer(ans/plot.res)+1
}




