\name{krige.grid}
\alias{krige.grid}
\title{ perform kriging on a rectangular grid }
\usage{
krige.grid(xsw, ysw, xne, yne, dx, dy, angle=NULL, point.obj, at, var.mod.obj, maxdist=NULL, extrap=F, trend=0, rsearch=0, nsearch=0, nsmin=-1, nsmax=-1, mode=1, covmode=1)
}
%- maybe also `usage' for other objects documented here.
\arguments{
 \item{xsw}{ x coordinate of south west corner of the grid }
 \item{ysw}{ y coordinate of south west corner of the grid }
 \item{xne}{ x coordinate of north east corner of the grid }
 \item{yne}{ y coordinate of north east corner of the grid }
 \item{dx}{ grid spacing in x direction }
 \item{dy}{ grid spacing in y direction }
 \item{angle}{ rotation of grid -- not yet implemented --}
 \item{point.obj}{ spatial data, class \code{"point"}}
 \item{at}{ name of variable of interest in \code{point.obj} }
 \item{var.mod.obj}{ variogram model  }
 \item{maxdist}{ synonym for  \code{rsearch}, for compatibility with
   \code{sgeostat}}
 \item{extrap}{logical, indicates whether to extrapolate beyond convex
   hull of data points, default \code{FALSE} }
 \item{trend}{ order of trend function }
 \item{rsearch}{ fixed search radius }
 \item{nsearch}{ fixed nearest neighbour search }
 \item{nsmin}{ minimum no of points in search neighbourhood, default 0}
 \item{nsmax}{ maximum no of points in search neighbourhood, default \code{length(point.obj[at])} }
 \item{mode}{1 - calculate krige prediction and variance, 2 - calculate
   only krige variance (usefull for network design purposes)}
}
\description{
 ~~ A concise (1-5 lines) description of what the function does. ~~
}
\details{
 ~~ If necessary, more details than the __description__  above ~~
}
\value{
  A list:
  \item{x }{vector of x coordinates of grid}
  \item{y }{vector of y coordinates of grid}
  \item{z }{matrix of predicted values, see also \code{mode}}
  \item{var }{matrix of prediction variances}
}
\references{ ~put references to the literature/web site here ~ }
\author{ ~~who you are~~ }
\note{ ~~further notes~~ }

 ~Make other sections like WARNING with \section{WARNING }{....} ~

 \seealso{ ~~objects to SEE ALSO as
   %- \code{\link{~~fun~~}}, ~~~
 }

\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	     or do  help(data=index)  for the standard data sets.
\testonly{
# prepare variables from other example pages if they are not already there:
if(length(ls(pat="maas.vmod"))==0){example(fit.variogram)}
}
# compare result and system.time() with example(krige) from library(sgeostat)
grid.fortran.krige <- krige.grid(min(maas$x), max(maas$x),min(maas$y), max(maas$y),100,100,point=maas.point, at="zinc", var.mod.obj=maas.vmod, rsearch = 1000, extrap = F)
}
\keyword{ ~keyword }%-- one or more ...
