\name{plot.tri}
\title{Plot a triangulation object}
\author{A. Gebhardt}
\usage{plot(tri.obj, add=FALSE, ...)
}
\alias{plot.tri}
\arguments{
  \item{tri.obj}{object of class \code{"tri"}}
  \item{add}{logical. if \code{TRUE}, add to a current plot.}
  \item{...}{additional plot parameters}
}
\description{plots the triangulation \code{"tri.obj"}
}
\value{None
}
\references{
   R. J. Renka (1996). Algorithm 751: TRIPACK: a constrained
  two-dimensional {Delaunay} triangulation package.
  ACM Transactions on Mathematical Software.
  \bold{22}, 1-8. 
}
\seealso{
  \code{\link{tri}}, \code{\link{print.tri}}, 
  \code{\link{summary.tri}}
}
\examples{
plot(tri.mesh(rpois(100,lambda=20),rpois(100,lambda=20),duplicate="remove"))
}
\keyword{}
